"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateDetailsContent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _eui = require("@elastic/eui");
var _constants = require("../../../../../../common/constants");
var _shared_imports = require("../../../../../shared_imports");
var _components = require("../../../../components");
var _api = require("../../../../services/api");
var _app_context = require("../../../../app_context");
var _shared = require("../../../../components/shared");
var _components2 = require("../components");
var _tabs = require("./tabs");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SUMMARY_TAB_ID = 'summary';
const MAPPINGS_TAB_ID = 'mappings';
const ALIASES_TAB_ID = 'aliases';
const SETTINGS_TAB_ID = 'settings';
const PREVIEW_TAB_ID = 'preview';
const TABS = [{
  id: SUMMARY_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.summaryTabTitle', {
    defaultMessage: 'Summary'
  })
}, {
  id: SETTINGS_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.settingsTabTitle', {
    defaultMessage: 'Settings'
  })
}, {
  id: MAPPINGS_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.mappingsTabTitle', {
    defaultMessage: 'Mappings'
  })
}, {
  id: ALIASES_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.aliasesTabTitle', {
    defaultMessage: 'Aliases'
  })
}, {
  id: PREVIEW_TAB_ID,
  name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.previewTabTitle', {
    defaultMessage: 'Preview'
  })
}];
const tabToUiMetricMap = {
  [SUMMARY_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_SUMMARY_TAB,
  [SETTINGS_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_SETTINGS_TAB,
  [MAPPINGS_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_MAPPINGS_TAB,
  [ALIASES_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_ALIASES_TAB,
  [PREVIEW_TAB_ID]: _constants.UIM_TEMPLATE_DETAIL_PANEL_PREVIEW_TAB
};
const TemplateDetailsContent = ({
  template: {
    name: templateName,
    isLegacy
  },
  onClose,
  editTemplate,
  cloneTemplate,
  reload
}) => {
  const {
    uiMetricService
  } = (0, _app_context.useServices)();
  const {
    error,
    data: templateDetails,
    isLoading
  } = (0, _api.useLoadIndexTemplate)(templateName, isLegacy);
  const isCloudManaged = (templateDetails === null || templateDetails === void 0 ? void 0 : templateDetails._kbnMeta.type) === 'cloudManaged';
  const [templateToDelete, setTemplateToDelete] = (0, _react.useState)([]);
  const [activeTab, setActiveTab] = (0, _react.useState)(SUMMARY_TAB_ID);
  const [isPopoverOpen, setIsPopOverOpen] = (0, _react.useState)(false);
  const renderHeader = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "templateDetailsFlyoutTitle",
      "data-test-subj": "title"
    }, templateName, templateDetails && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_components2.TemplateTypeIndicator, {
      templateType: templateDetails._kbnMeta.type
    })))));
  };
  const renderBody = () => {
    if (isLoading) {
      return /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateDetails.loadingIndexTemplateDescription",
        defaultMessage: "Loading template\u2026"
      }));
    }
    if (error) {
      return /*#__PURE__*/_react.default.createElement(_components.SectionError, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.templateDetails.loadingIndexTemplateErrorMessage",
          defaultMessage: "Error loading template"
        }),
        error: error,
        "data-test-subj": "sectionError"
      });
    }
    if (templateDetails) {
      const {
        template: {
          settings,
          mappings,
          aliases
        } = {}
      } = templateDetails;
      const tabToComponentMap = {
        [SUMMARY_TAB_ID]: /*#__PURE__*/_react.default.createElement(_tabs.TabSummary, {
          templateDetails: templateDetails
        }),
        [SETTINGS_TAB_ID]: /*#__PURE__*/_react.default.createElement(_shared.TabSettings, {
          settings: settings
        }),
        [MAPPINGS_TAB_ID]: /*#__PURE__*/_react.default.createElement(_shared.TabMappings, {
          mappings: mappings
        }),
        [ALIASES_TAB_ID]: /*#__PURE__*/_react.default.createElement(_shared.TabAliases, {
          aliases: aliases
        }),
        [PREVIEW_TAB_ID]: /*#__PURE__*/_react.default.createElement(_tabs.TabPreview, {
          templateDetails: templateDetails
        })
      };
      const tabContent = tabToComponentMap[activeTab];
      const managedTemplateCallout = isCloudManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.templateDetails.cloudManagedTemplateInfoTitle",
          defaultMessage: "Editing a cloud-managed template is not permitted."
        }),
        color: "primary",
        size: "s"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateDetails.cloudManagedTemplateInfoDescription",
        defaultMessage: "Cloud-managed templates are critical for internal operations."
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "m"
      }));
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, managedTemplateCallout, /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, TABS.filter(tab => {
        // Legacy index templates don't have the "simulate" template API
        if (isLegacy && tab.id === PREVIEW_TAB_ID) {
          return false;
        }
        return true;
      }).map(tab => /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => {
          uiMetricService.trackMetric(_analytics.METRIC_TYPE.CLICK, tabToUiMetricMap[tab.id]);
          setActiveTab(tab.id);
        },
        isSelected: tab.id === activeTab,
        key: tab.id,
        "data-test-subj": "tab"
      }, tab.name))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "l"
      }), tabContent);
    }
  };
  const renderFooter = () => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "spaceBetween",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      iconType: "cross",
      flush: "left",
      onClick: onClose,
      "data-test-subj": "closeDetailsButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.templateDetails.closeButtonLabel",
      defaultMessage: "Close"
    }))), templateDetails && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      id: "manageTemplatePanel",
      button: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "manageTemplateButton",
        iconType: "arrowDown",
        iconSide: "right",
        onClick: () => setIsPopOverOpen(prev => !prev)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.templateDetails.manageButtonLabel",
        defaultMessage: "Manage"
      })),
      isOpen: isPopoverOpen,
      closePopover: () => setIsPopOverOpen(false),
      panelPaddingSize: "none",
      anchorPosition: "rightUp",
      repositionOnScroll: true
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
      initialPanelId: 0,
      panels: [{
        id: 0,
        title: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.manageContextMenuPanelTitle', {
          defaultMessage: 'Template options'
        }),
        items: [{
          name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.editButtonLabel', {
            defaultMessage: 'Edit'
          }),
          icon: 'pencil',
          onClick: () => editTemplate(templateName, isLegacy),
          disabled: isCloudManaged
        }, {
          name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.cloneButtonLabel', {
            defaultMessage: 'Clone'
          }),
          icon: 'copy',
          onClick: () => cloneTemplate(templateName, isLegacy)
        }, {
          name: _i18n.i18n.translate('xpack.idxMgmt.templateDetails.deleteButtonLabel', {
            defaultMessage: 'Delete'
          }),
          icon: 'trash',
          onClick: () => setTemplateToDelete([{
            name: templateName,
            isLegacy
          }]),
          disabled: isCloudManaged
        }]
      }]
    })))));
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, renderHeader(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content"
  }, renderBody()), renderFooter(), templateToDelete && templateToDelete.length > 0 ? /*#__PURE__*/_react.default.createElement(_components.TemplateDeleteModal, {
    callback: data => {
      if (data && data.hasDeletedTemplates) {
        reload();
      } else {
        setTemplateToDelete([]);
      }
      onClose();
    },
    templatesToDelete: templateToDelete
  }) : null);
};
exports.TemplateDetailsContent = TemplateDetailsContent;