"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexActionsContextMenu = void 0;
var _reactRedux = require("react-redux");
var _index_actions_context_menu = require("./index_actions_context_menu");
var _constants = require("../../../../constants");
var _actions = require("../../../../store/actions");
var _selectors = require("../../../../store/selectors");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const mapStateToProps = (state, ownProps) => {
  const indexStatusByName = {};
  const {
    indexNames
  } = ownProps;
  const allIndices = state.indices.byId;
  indexNames.forEach(indexName => {
    indexStatusByName[indexName] = (0, _selectors.getIndexStatusByIndexName)(state, indexName);
  });
  return {
    indexStatusByName,
    indices: (0, _selectors.getIndicesByName)(state, indexNames),
    isSystemIndexByName: (0, _selectors.getIsSystemIndexByName)(indexNames, allIndices),
    hasSystemIndex: (0, _selectors.hasSystemIndex)(indexNames, allIndices)
  };
};
const mapDispatchToProps = (dispatch, {
  indexNames
}) => {
  return {
    editIndexSettings: () => {
      dispatch((0, _actions.editIndexSettings)({
        indexName: indexNames[0]
      }));
    },
    clearCacheIndices: () => {
      dispatch((0, _actions.clearCacheIndices)({
        indexNames
      }));
    },
    closeIndices: () => {
      dispatch((0, _actions.closeIndices)({
        indexNames
      }));
    },
    flushIndices: () => {
      dispatch((0, _actions.flushIndices)({
        indexNames
      }));
    },
    openIndices: () => {
      dispatch((0, _actions.openIndices)({
        indexNames
      }));
    },
    refreshIndices: () => {
      dispatch((0, _actions.refreshIndices)({
        indexNames
      }));
    },
    unfreezeIndices: () => {
      dispatch((0, _actions.unfreezeIndices)({
        indexNames
      }));
    },
    forcemergeIndices: maxNumSegments => {
      dispatch((0, _actions.forcemergeIndices)({
        indexNames,
        maxNumSegments
      }));
    },
    showSettings: () => {
      dispatch((0, _actions.openDetailPanel)({
        indexName: indexNames[0],
        panelType: _constants.TAB_SETTINGS
      }));
    },
    showMapping: () => {
      dispatch((0, _actions.openDetailPanel)({
        indexName: indexNames[0],
        panelType: _constants.TAB_MAPPING
      }));
    },
    showStats: () => {
      dispatch((0, _actions.openDetailPanel)({
        indexName: indexNames[0],
        panelType: _constants.TAB_STATS
      }));
    },
    editIndex: () => {
      const indexName = indexNames ? indexNames[0] : null;
      if (indexName) {
        dispatch((0, _actions.openDetailPanel)({
          indexName,
          panelType: _constants.TAB_EDIT_SETTINGS
        }));
      }
    },
    deleteIndices: () => {
      dispatch((0, _actions.deleteIndices)({
        indexNames
      }));
    },
    reloadIndices: () => {
      dispatch((0, _actions.reloadIndices)(indexNames));
    },
    performExtensionAction: (requestMethod, successMessage) => {
      dispatch((0, _actions.performExtensionAction)({
        requestMethod,
        successMessage,
        indexNames
      }));
    }
  };
};
const IndexActionsContextMenu = (0, _reactRedux.connect)(mapStateToProps, mapDispatchToProps)(_index_actions_context_menu.IndexActionsContextMenu);
exports.IndexActionsContextMenu = IndexActionsContextMenu;