"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Summary = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _components = require("../../../../../components");
var _app_context = require("../../../../../app_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHeaders = () => {
  return {
    health: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.healthHeader', {
      defaultMessage: 'Health'
    }),
    status: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.statusHeader', {
      defaultMessage: 'Status'
    }),
    primary: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.primaryHeader', {
      defaultMessage: 'Primaries'
    }),
    replica: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.replicaHeader', {
      defaultMessage: 'Replicas'
    }),
    documents: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.documentsHeader', {
      defaultMessage: 'Docs count'
    }),
    documents_deleted: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.deletedDocumentsHeader', {
      defaultMessage: 'Docs deleted'
    }),
    size: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.storageSizeHeader', {
      defaultMessage: 'Storage size'
    }),
    primary_size: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.primaryStorageSizeHeader', {
      defaultMessage: 'Primary storage size'
    }),
    aliases: _i18n.i18n.translate('xpack.idxMgmt.summary.headers.aliases', {
      defaultMessage: 'Aliases'
    })
  };
};
class Summary extends _react.default.PureComponent {
  getAdditionalContent(extensionsService, getUrlForApp) {
    const {
      index
    } = this.props;
    const extensions = extensionsService.summaries;
    return extensions.map((summaryExtension, i) => {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: `summaryExtension-${i}`
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, null), summaryExtension(index, getUrlForApp));
    });
  }
  buildRows() {
    const {
      index
    } = this.props;
    const headers = getHeaders();
    const rows = {
      left: [],
      right: []
    };
    Object.keys(headers).forEach((fieldName, arrayIndex) => {
      const value = index[fieldName];
      let content = value;
      if (fieldName === 'health') {
        content = /*#__PURE__*/_react.default.createElement(_components.DataHealth, {
          health: value
        });
      }
      if (Array.isArray(content)) {
        content = content.join(', ');
      }
      const cell = [/*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
        key: fieldName
      }, /*#__PURE__*/_react.default.createElement("strong", null, headers[fieldName])), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
        key: fieldName + '_desc'
      }, content)];
      if (arrayIndex % 2 === 0) {
        rows.left.push(cell);
      } else {
        rows.right.push(cell);
      }
    });
    return rows;
  }
  render() {
    return /*#__PURE__*/_react.default.createElement(_app_context.AppContextConsumer, null, ({
      services,
      core
    }) => {
      const {
        left,
        right
      } = this.buildRows();
      const additionalContent = this.getAdditionalContent(services.extensionsService, core.getUrlForApp);
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        size: "s"
      }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.summary.summaryTitle",
        defaultMessage: "General"
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        size: "s"
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        type: "column"
      }, left)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
        type: "column"
      }, right))), additionalContent);
    });
  }
}
exports.Summary = Summary;