"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShowJson = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
require("brace/theme/textmate");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ShowJson extends _react.default.PureComponent {
  UNSAFE_componentWillMount() {
    this.props.loadIndexData(this.props);
  }
  UNSAFE_componentWillUpdate(newProps) {
    const {
      data,
      loadIndexData
    } = newProps;
    if (!data) {
      loadIndexData(newProps);
    }
  }
  render() {
    const {
      data
    } = this.props;
    if (!data) {
      return null;
    }
    const json = JSON.stringify(data, null, 2);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json"
    }, json);
  }
}
exports.ShowJson = ShowJson;