"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DetailPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRouterDom = require("react-router-dom");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _render_badges = require("../../../../lib/render_badges");
var _constants = require("../../../../../../common/constants");
var _constants2 = require("../../../../constants");
var _index_actions_context_menu = require("../index_actions_context_menu");
var _show_json = require("./show_json");
var _summary = require("./summary");
var _edit_settings_json = require("./edit_settings_json");
var _app_context = require("../../../../app_context");
var _render_discover_link = require("../../../../lib/render_discover_link");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// eslint-disable-next-line no-restricted-imports

const tabToHumanizedMap = {
  [_constants2.TAB_SUMMARY]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.detailPanel.tabSummaryLabel",
    defaultMessage: "Summary"
  }),
  [_constants2.TAB_SETTINGS]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.detailPanel.tabSettingsLabel",
    defaultMessage: "Settings"
  }),
  [_constants2.TAB_MAPPING]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.detailPanel.tabMappingLabel",
    defaultMessage: "Mappings"
  }),
  [_constants2.TAB_STATS]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.detailPanel.tabStatsLabel",
    defaultMessage: "Stats"
  }),
  [_constants2.TAB_EDIT_SETTINGS]: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.detailPanel.tabEditSettingsLabel",
    defaultMessage: "Edit settings"
  })
};
const tabs = [_constants2.TAB_SUMMARY, _constants2.TAB_SETTINGS, _constants2.TAB_MAPPING, _constants2.TAB_STATS, _constants2.TAB_EDIT_SETTINGS];
const DetailPanel = ({
  panelType,
  indexName,
  index,
  openDetailPanel,
  closeDetailPanel
}) => {
  const {
    extensionsService
  } = (0, _app_context.useServices)();
  const renderTabs = () => {
    return tabs.map((tab, i) => {
      const isSelected = tab === panelType;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
        onClick: () => openDetailPanel({
          panelType: tab,
          indexName
        }),
        isSelected: isSelected,
        "data-test-subj": `detailPanelTab${isSelected ? 'Selected' : ''}`,
        disabled: tab === _constants2.TAB_STATS && index.status !== _constants.INDEX_OPEN,
        key: i
      }, tabToHumanizedMap[tab]);
    });
  };
  if (!panelType) {
    return null;
  }
  let component = null;
  switch (panelType) {
    case _constants2.TAB_EDIT_SETTINGS:
      component = /*#__PURE__*/_react.default.createElement(_edit_settings_json.EditSettingsJson, null);
      break;
    case _constants2.TAB_MAPPING:
    case _constants2.TAB_SETTINGS:
    case _constants2.TAB_STATS:
      component = /*#__PURE__*/_react.default.createElement(_show_json.ShowJson, null);
      break;
    default:
      component = /*#__PURE__*/_react.default.createElement(_summary.Summary, null);
  }
  const content = index ? /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, component), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_reactRouterDom.Route, {
    key: "menu",
    render: () => /*#__PURE__*/_react.default.createElement(_index_actions_context_menu.IndexActionsContextMenu, {
      iconSide: "left",
      indexNames: [indexName],
      anchorPosition: "upRight",
      detailPanel: true,
      iconType: "arrowUp",
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.detailPanel.manageContextMenuLabel",
        defaultMessage: "Manage"
      })
    })
  }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.detailPanel.missingIndexTitle",
      defaultMessage: "Missing index"
    }),
    color: "danger",
    iconType: "cross"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.detailPanel.missingIndexMessage",
    defaultMessage: "This index does not exist. It might have been deleted by a running job or another system."
  })));
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    "data-test-subj": "indexDetailFlyout",
    onClose: closeDetailPanel,
    "aria-labelledby": "indexDetailsFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    id: "indexDetailsFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, indexName, (0, _render_discover_link.renderDiscoverLink)(indexName), (0, _render_badges.renderBadges)(index, undefined, extensionsService))), index ? /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, null, renderTabs()) : null), content);
};
exports.DetailPanel = DetailPanel;