"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../shared_imports");
var _routing = require("../../../../services/routing");
var _components = require("../../../../components");
var _delete_data_stream_confirmation_modal = require("../delete_data_stream_confirmation_modal");
var _humanize_time_stamp = require("../humanize_time_stamp");
var _data_stream_badges = require("../data_stream_badges");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DataStreamTable = ({
  dataStreams,
  reload,
  history,
  filters,
  includeStats
}) => {
  const [selection, setSelection] = (0, _react.useState)([]);
  const [dataStreamsToDelete, setDataStreamsToDelete] = (0, _react.useState)([]);
  const columns = [];
  columns.push({
    field: 'name',
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.nameColumnTitle', {
      defaultMessage: 'Name'
    }),
    truncateText: true,
    sortable: true,
    render: (name, dataStream) => {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": "nameLink"
      }, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getDataStreamDetailsLink)(name))), name), /*#__PURE__*/_react.default.createElement(_data_stream_badges.DataStreamsBadges, {
        dataStream: dataStream
      }));
    }
  });
  columns.push({
    field: 'health',
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.healthColumnTitle', {
      defaultMessage: 'Health'
    }),
    truncateText: true,
    sortable: true,
    render: health => {
      return /*#__PURE__*/_react.default.createElement(_components.DataHealth, {
        health: health
      });
    },
    width: '100px'
  });
  if (includeStats) {
    columns.push({
      field: 'maxTimeStamp',
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.maxTimeStampColumnTitle', {
        defaultMessage: 'Last updated'
      }),
      width: '300px',
      truncateText: true,
      sortable: true,
      render: maxTimeStamp => maxTimeStamp ? (0, _humanize_time_stamp.humanizeTimeStamp)(maxTimeStamp) : _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.maxTimeStampColumnNoneMessage', {
        defaultMessage: 'Never'
      })
    });
    columns.push({
      field: 'storageSizeBytes',
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.storageSizeColumnTitle', {
        defaultMessage: 'Storage size'
      }),
      truncateText: true,
      sortable: true,
      render: (storageSizeBytes, dataStream) => dataStream.storageSize
    });
  }
  columns.push({
    field: 'indices',
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.indicesColumnTitle', {
      defaultMessage: 'Indices'
    }),
    truncateText: true,
    sortable: true,
    render: (indices, dataStream) => /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
      "data-test-subj": "indicesLink"
    }, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getIndexListUri)(`data_stream="${dataStream.name}"`, true))), indices.length)
  });
  columns.push({
    name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.actionColumnTitle', {
      defaultMessage: 'Actions'
    }),
    actions: [{
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.actionDeleteText', {
        defaultMessage: 'Delete'
      }),
      description: _i18n.i18n.translate('xpack.idxMgmt.dataStreamList.table.actionDeleteDescription', {
        defaultMessage: 'Delete this data stream'
      }),
      icon: 'trash',
      color: 'danger',
      type: 'icon',
      onClick: ({
        name
      }) => {
        setDataStreamsToDelete([name]);
      },
      isPrimary: true,
      'data-test-subj': 'deleteDataStream',
      available: ({
        privileges: {
          delete_index: deleteIndex
        }
      }) => deleteIndex
    }]
  });
  const pagination = {
    initialPageSize: 20,
    pageSizeOptions: [10, 20, 50]
  };
  const sorting = {
    sort: {
      field: 'name',
      direction: 'asc'
    }
  };
  const selectionConfig = {
    onSelectionChange: setSelection
  };
  const searchConfig = {
    query: filters,
    box: {
      incremental: true
    },
    toolsLeft: selection.length > 0 && selection.every(dataStream => dataStream.privileges.delete_index) ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "deleteDataStreamsButton",
      onClick: () => setDataStreamsToDelete(selection.map(({
        name
      }) => name)),
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.table.deleteDataStreamsButtonLabel",
      defaultMessage: "Delete {count, plural, one {data stream} other {data streams} }",
      values: {
        count: selection.length
      }
    })) : undefined,
    toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      color: "success",
      iconType: "refresh",
      onClick: reload,
      "data-test-subj": "reloadButton",
      key: "reloadButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.reloadDataStreamsButtonLabel",
      defaultMessage: "Reload"
    }))]
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, dataStreamsToDelete && dataStreamsToDelete.length > 0 ? /*#__PURE__*/_react.default.createElement(_delete_data_stream_confirmation_modal.DeleteDataStreamConfirmationModal, {
    onClose: data => {
      if (data && data.hasDeletedDataStreams) {
        reload();
      } else {
        setDataStreamsToDelete([]);
      }
    },
    dataStreams: dataStreamsToDelete
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    items: dataStreams || [],
    itemId: "name",
    columns: columns,
    search: searchConfig,
    sorting: sorting,
    isSelectable: true,
    selection: selectionConfig,
    pagination: pagination,
    rowProps: () => ({
      'data-test-subj': 'row'
    }),
    cellProps: () => ({
      'data-test-subj': 'cell'
    }),
    "data-test-subj": "dataStreamTable",
    message: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.dataStreamList.table.noDataStreamsMessage",
      defaultMessage: "No data streams found"
    }),
    tableLayout: 'auto'
  }));
};
exports.DataStreamTable = DataStreamTable;