"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DataStreamDetailPanel = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _render_discover_link = require("../../../../lib/render_discover_link");
var _shared_imports = require("../../../../../shared_imports");
var _components = require("../../../../components");
var _api = require("../../../../services/api");
var _delete_data_stream_confirmation_modal = require("../delete_data_stream_confirmation_modal");
var _humanize_time_stamp = require("../humanize_time_stamp");
var _routing = require("../../../../services/routing");
var _constants = require("../../../../constants");
var _app_context = require("../../../../app_context");
var _data_stream_badges = require("../data_stream_badges");
var _use_ilm_locator = require("../../../../services/use_ilm_locator");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DetailsList = ({
  details
}) => {
  const groups = [];
  let items;
  details.forEach((detail, index) => {
    const {
      name,
      toolTip,
      content
    } = detail;
    if (index % 2 === 0) {
      items = [];
      groups.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        key: groups.length
      }, items));
    }
    items.push( /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      key: name
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, toolTip && /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: toolTip,
      position: "top"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, null, content)));
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    textStyle: "reverse"
  }, groups);
};
const DataStreamDetailPanel = ({
  dataStreamName,
  onClose
}) => {
  const {
    error,
    data: dataStream,
    isLoading
  } = (0, _api.useLoadDataStream)(dataStreamName);
  const [isDeleting, setIsDeleting] = (0, _react.useState)(false);
  const ilmPolicyLink = (0, _use_ilm_locator.useIlmLocator)(_constants.ILM_PAGES_POLICY_EDIT, dataStream === null || dataStream === void 0 ? void 0 : dataStream.ilmPolicyName);
  const {
    history
  } = (0, _app_context.useAppContext)();
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_shared_imports.SectionLoading, null, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.loadingDataStreamDescription', {
      defaultMessage: 'Loading data stream'
    }));
  } else if (error) {
    content = /*#__PURE__*/_react.default.createElement(_components.SectionError, {
      title: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.loadingDataStreamErrorMessage', {
        defaultMessage: 'Error loading data stream'
      }),
      error: error,
      "data-test-subj": "sectionError"
    });
  } else if (dataStream) {
    const {
      health,
      indices,
      timeStampField,
      generation,
      indexTemplateName,
      ilmPolicyName,
      storageSize,
      maxTimeStamp
    } = dataStream;
    const details = [{
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.healthTitle', {
        defaultMessage: 'Health'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.healthToolTip', {
        defaultMessage: `The health of the data stream's current backing indices`
      }),
      content: /*#__PURE__*/_react.default.createElement(_components.DataHealth, {
        health: health
      })
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.maxTimeStampTitle', {
        defaultMessage: 'Last updated'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.maxTimeStampToolTip', {
        defaultMessage: 'The most recent document to be added to the data stream'
      }),
      content: maxTimeStamp ? (0, _humanize_time_stamp.humanizeTimeStamp)(maxTimeStamp) : /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.maxTimeStampNoneMessage', {
        defaultMessage: `Never`
      }))
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.storageSizeTitle', {
        defaultMessage: 'Storage size'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.storageSizeToolTip', {
        defaultMessage: `Total size of all shards in the data stream’s backing indices`
      }),
      content: storageSize
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indicesTitle', {
        defaultMessage: 'Indices'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indicesToolTip', {
        defaultMessage: `The data stream's current backing indices`
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getIndexListUri)(`data_stream="${dataStreamName}"`, true)), indices.length)
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.timestampFieldTitle', {
        defaultMessage: 'Timestamp field'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.timestampFieldToolTip', {
        defaultMessage: 'Timestamp field shared by all documents in the data stream'
      }),
      content: timeStampField.name
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.generationTitle', {
        defaultMessage: 'Generation'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.generationToolTip', {
        defaultMessage: 'Cumulative count of backing indices created for the data stream'
      }),
      content: generation
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indexTemplateTitle', {
        defaultMessage: 'Index template'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.indexTemplateToolTip', {
        defaultMessage: 'The index template that configured the data stream and configures its backing indices'
      }),
      content: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({
        "data-test-subj": 'indexTemplateLink'
      }, (0, _shared_imports.reactRouterNavigate)(history, (0, _routing.getTemplateDetailsLink)(indexTemplateName))), indexTemplateName)
    }, {
      name: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.ilmPolicyTitle', {
        defaultMessage: 'Index lifecycle policy'
      }),
      toolTip: _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.ilmPolicyToolTip', {
        defaultMessage: `The index lifecycle policy that manages the data stream's data`
      }),
      content: ilmPolicyName && ilmPolicyLink ? /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        "data-test-subj": 'ilmPolicyLink',
        href: ilmPolicyLink
      }, ilmPolicyName) : ilmPolicyName || /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.ilmPolicyContentNoneMessage', {
        defaultMessage: `None`
      }))
    }];
    content = /*#__PURE__*/_react.default.createElement(DetailsList, {
      details: details
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDeleting ? /*#__PURE__*/_react.default.createElement(_delete_data_stream_confirmation_modal.DeleteDataStreamConfirmationModal, {
    onClose: data => {
      if (data && data.hasDeletedDataStreams) {
        onClose(true);
      } else {
        setIsDeleting(false);
      }
    },
    dataStreams: [dataStreamName]
  }) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    onClose: () => onClose(),
    "data-test-subj": "dataStreamDetailPanel",
    "aria-labelledby": "dataStreamDetailPanelTitle",
    size: "m",
    maxWidth: 500
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("h2", {
    id: "dataStreamDetailPanelTitle",
    "data-test-subj": "dataStreamDetailPanelTitle"
  }, dataStreamName, (0, _render_discover_link.renderDiscoverLink)(dataStreamName), dataStream && /*#__PURE__*/_react.default.createElement(_data_stream_badges.DataStreamsBadges, {
    dataStream: dataStream
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, {
    "data-test-subj": "content"
  }, content), /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "cross",
    flush: "left",
    onClick: () => onClose(),
    "data-test-subj": "closeDetailsButton"
  }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.closeButtonLabel', {
    defaultMessage: 'Close'
  }))), !isLoading && !error && dataStream !== null && dataStream !== void 0 && dataStream.privileges.delete_index ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    color: "danger",
    iconType: "trash",
    onClick: () => setIsDeleting(true),
    "data-test-subj": "deleteDataStreamButton"
  }, _i18n.i18n.translate('xpack.idxMgmt.dataStreamDetailPanel.deleteButtonLabel', {
    defaultMessage: 'Delete data stream'
  }))) : null))));
};
exports.DataStreamDetailPanel = DataStreamDetailPanel;