"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderDiscoverLink = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _app_context = require("../app_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const renderDiscoverLink = indexName => {
  return /*#__PURE__*/_react.default.createElement(_app_context.AppContextConsumer, null, ctx => {
    var _ctx$url;
    const locators = ctx === null || ctx === void 0 ? void 0 : (_ctx$url = ctx.url) === null || _ctx$url === void 0 ? void 0 : _ctx$url.locators.get('DISCOVER_APP_LOCATOR');
    if (!locators) {
      return null;
    }
    const onClick = async () => {
      await locators.navigate({
        dataViewSpec: {
          title: indexName
        }
      });
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
      content: _i18n.i18n.translate('xpack.idxMgmt.goToDiscover', {
        defaultMessage: 'Show {indexName} in Discover',
        values: {
          indexName
        }
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
      onClick: onClick,
      display: "empty",
      size: "xs",
      iconType: "discoverApp",
      "aria-label": "Discover",
      "data-test-subj": "indexDetailFlyoutDiscover",
      css: {
        margin: '0 0.3em'
      }
    }));
  });
};
exports.renderDiscoverLink = renderDiscoverLink;