"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isSystemIndex = exports.isHiddenIndex = void 0;
var _semver = _interopRequireDefault(require("semver/classes/semver"));
var _common = require("../../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const kibanaVersion = new _semver.default(_common.MAJOR_VERSION);
const isHiddenIndex = index => {
  if (kibanaVersion.major < 8) {
    var _index$name;
    // In 7.x we consider hidden index all indices whose name start with a dot
    return ((_index$name = index.name) !== null && _index$name !== void 0 ? _index$name : '').startsWith('.') || index.hidden === true;
  }
  return index.hidden === true;
};
exports.isHiddenIndex = isHiddenIndex;
const isSystemIndex = index => {
  if (kibanaVersion.major < 8) {
    var _index$name2;
    return ((_index$name2 = index.name) !== null && _index$name2 !== void 0 ? _index$name2 : '').startsWith('.');
  }
  // From 8.0 we won't surface system indices in Index management
  return false;
};
exports.isSystemIndex = isSystemIndex;