"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.flattenObject = void 0;
var _lodash = _interopRequireDefault(require("lodash"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const flattenObject = (nestedObj, flattenArrays) => {
  const stack = []; // track key stack
  const flatObj = {};
  const dot = '.';
  (function flattenObj(obj) {
    _lodash.default.keys(obj).forEach(function (key) {
      stack.push(key);
      if (!flattenArrays && Array.isArray(obj[key])) flatObj[stack.join(dot)] = obj[key];else if (_lodash.default.isObject(obj[key])) flattenObj(obj[key]);else flatObj[stack.join(dot)] = obj[key];
      stack.pop();
    });
  })(nestedObj);
  return flatObj;
};
exports.flattenObject = flattenObject;