"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TemplateContentIndicator = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const texts = {
  settings: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.indexSettingsTooltipLabel', {
    defaultMessage: 'Index settings'
  }),
  mappings: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.mappingsTooltipLabel', {
    defaultMessage: 'Mappings'
  }),
  aliases: _i18n.i18n.translate('xpack.idxMgmt.templateContentIndicator.aliasesTooltipLabel', {
    defaultMessage: 'Aliases'
  })
};
const TemplateContentIndicator = ({
  mappings,
  settings,
  aliases,
  contentWhenEmpty = null
}) => {
  const getColor = flag => flag ? 'primary' : 'hollow';
  if (!mappings && !settings && !aliases) {
    return contentWhenEmpty;
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: texts.mappings
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getColor(mappings)
  }, "M"), "\xA0")), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: texts.settings
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getColor(settings)
  }, "S"), "\xA0")), /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: texts.aliases
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: getColor(aliases)
  }, "A")));
};
exports.TemplateContentIndicator = TemplateContentIndicator;