"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchResult = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactTinyVirtualList = _interopRequireDefault(require("react-tiny-virtual-list"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mappings_state_context = require("../../../mappings_state_context");
var _search_result_item = require("./search_result_item");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ITEM_HEIGHT = 64;
const SearchResult = /*#__PURE__*/_react.default.memo(({
  result,
  documentFieldsState: {
    status,
    fieldToEdit
  },
  style: virtualListStyle
}) => {
  const dispatch = (0, _mappings_state_context.useDispatch)();
  const listHeight = Math.min(result.length * ITEM_HEIGHT, 600);
  const clearSearch = () => {
    dispatch({
      type: 'search:update',
      value: ''
    });
  };
  return result.length === 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    "data-test-subj": "mappingsEditorSearchResultEmptyPrompt",
    iconType: "search",
    title: /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.searchResult.emptyPromptTitle",
      defaultMessage: "No fields match your search"
    })),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: clearSearch
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.mappingsEditor.searchResult.emptyPrompt.clearSearchButtonLabel",
      defaultMessage: "Clear search"
    }))
  }) : /*#__PURE__*/_react.default.createElement(_reactTinyVirtualList.default, {
    "data-test-subj": "mappingsEditorSearchResult",
    style: {
      overflowX: 'hidden',
      ...virtualListStyle
    },
    width: "100%",
    height: listHeight,
    itemCount: result.length,
    itemSize: ITEM_HEIGHT,
    overscanCount: 4,
    renderItem: ({
      index,
      style
    }) => {
      const item = result[index];
      return /*#__PURE__*/_react.default.createElement("div", {
        key: item.field.id,
        style: style
      }, /*#__PURE__*/_react.default.createElement(_search_result_item.SearchResultItem, {
        item: item,
        areActionButtonsVisible: status === 'idle',
        isDimmed: status === 'editingField' && fieldToEdit !== item.field.id,
        isHighlighted: status === 'editingField' && fieldToEdit === item.field.id
      }));
    }
  });
});
exports.SearchResult = SearchResult;
SearchResult.displayName = 'SearchResult'; // display name required for tests to work with React.memo