"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShapeType = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _lib = require("../../../../lib");
var _edit_field = require("../edit_field");
var _field_parameters = require("../../field_parameters");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDefaultToggleValue = (param, field) => {
  const {
    defaultValue
  } = (0, _lib.getFieldConfig)(param);
  switch (param) {
    // Switches that don't map to a boolean in the mappings
    case 'boost':
    case 'orientation':
      {
        return field[param] !== undefined && field[param] !== defaultValue;
      }
    default:
      // All "boolean" parameters
      return field[param] !== undefined ? field[param] // If the field has a value set, use it
      : defaultValue !== undefined // If the parameter definition has a "defaultValue" set, use it
      ? defaultValue : false;
    // Defaults to "false"
  }
};

const ShapeType = ({
  field
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_edit_field.BasicParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.IgnoreMalformedParameter, {
    description: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.shapeType.ignoredMalformedFieldDescription', {
      defaultMessage: 'By default, documents that contain malformed GeoJSON or WKT shapes are not indexed. If enabled, these documents are indexed, but fields with malformed shapes are filtered out. Be careful: if too many documents are indexed this way, queries on the field become meaningless.'
    })
  })), /*#__PURE__*/_react.default.createElement(_edit_field.AdvancedParametersSection, null, /*#__PURE__*/_react.default.createElement(_field_parameters.OrientationParameter, {
    defaultToggleValue: getDefaultToggleValue('orientation', field.source)
  }), /*#__PURE__*/_react.default.createElement(_field_parameters.IgnoreZValueParameter, null), /*#__PURE__*/_react.default.createElement(_field_parameters.CoerceShapeParameter, null)));
};
exports.ShapeType = ShapeType;