"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FieldDescriptionSection = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FieldDescriptionSection = ({
  children,
  isMultiField
}) => {
  if (!children && !isMultiField) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement("section", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, children, isMultiField && /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.multiFieldIntroductionText', {
    defaultMessage: 'This field is a multi-field. You can use multi-fields to index the same field in different ways.'
  }))));
};
exports.FieldDescriptionSection = FieldDescriptionSection;