"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SubTypeParameter = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
var _lib = require("../../../lib");
var _constants = require("../../../constants");
var _other_type_name_parameter = require("./other_type_name_parameter");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SubTypeParameter = ({
  type,
  defaultValueType,
  isMultiField,
  isRootLevelField
}) => {
  if (type === 'other') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_other_type_name_parameter.OtherTypeNameParameter, null));
  }
  const typeDefinition = _constants.TYPE_DEFINITION[type];
  const hasSubType = typeDefinition.subTypes !== undefined;
  if (!hasSubType) {
    return null;
  }

  // Field sub type (if any)
  const subTypeOptions = typeDefinition.subTypes.types.map(_subType => _constants.TYPE_DEFINITION[_subType]).map(_subType => ({
    value: _subType.value,
    label: _subType.label
  }));
  const defaultValueSubType = typeDefinition.subTypes.types.includes(defaultValueType) ? defaultValueType // we use the default value provided
  : typeDefinition.subTypes.types[0]; // we set the first item from the subType array;

  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "subType",
    defaultValue: defaultValueSubType,
    config: {
      ...(0, _lib.getFieldConfig)('type'),
      label: typeDefinition.subTypes.label
    }
  }, subTypeField => {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: subTypeField.label
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
      placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.subTypeField.placeholderLabel', {
        defaultMessage: 'Select a type'
      }),
      singleSelection: {
        asPlainText: true
      },
      options: isMultiField ? (0, _lib.filterTypesForMultiField)(subTypeOptions) : isRootLevelField ? subTypeOptions : (0, _lib.filterTypesForNonRootFields)(subTypeOptions),
      selectedOptions: subTypeField.value,
      onChange: subTypeField.setValue,
      isClearable: false,
      "data-test-subj": "fieldSubType"
    }));
  }));
};
exports.SubTypeParameter = SubTypeParameter;