"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnalyzerParameterSelects = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const areOptionsSuperSelect = options => {
  if (!options || !Boolean(options.length)) {
    return false;
  }
  // `Select` options have a "text" property, `SuperSelect` options don't have it.
  return {}.hasOwnProperty.call(options[0], 'text') === false;
};
const AnalyzerParameterSelects = ({
  onChange,
  mainDefaultValue,
  subDefaultValue,
  config,
  options,
  mapOptionsToSubOptions,
  'data-test-subj': dataTestSubj
}) => {
  const {
    form
  } = (0, _shared_imports.useForm)({
    defaultValue: {
      main: mainDefaultValue,
      sub: subDefaultValue
    }
  });
  const {
    subscribe
  } = form;
  (0, _react.useEffect)(() => {
    const subscription = subscribe(updateData => {
      const formData = updateData.data.internal;
      const value = formData.sub ? formData.sub : formData.main;
      onChange(value);
    });
    return subscription.unsubscribe;
  }, [subscribe, onChange]);
  const getSubOptionsMeta = (0, _react.useCallback)(mainValue => mapOptionsToSubOptions !== undefined ? mapOptionsToSubOptions[mainValue] : undefined, [mapOptionsToSubOptions]);
  const onMainValueChange = (0, _react.useCallback)(mainValue => {
    const subOptionsMeta = getSubOptionsMeta(mainValue);
    form.setFieldValue('sub', subOptionsMeta ? subOptionsMeta.options[0].value : undefined);
  }, [form, getSubOptionsMeta]);
  const renderSelect = (field, opts) => {
    const isSuperSelect = areOptionsSuperSelect(opts);
    return isSuperSelect ? /*#__PURE__*/_react.default.createElement(_shared_imports.SuperSelectField, {
      field: field,
      euiFieldProps: {
        options: opts
      },
      "data-test-subj": dataTestSubj
    }) : /*#__PURE__*/_react.default.createElement(_shared_imports.SelectField, {
      field: field,
      euiFieldProps: {
        options: opts,
        hasNoInitialSelection: false
      },
      "data-test-subj": dataTestSubj
    });
  };
  return /*#__PURE__*/_react.default.createElement(_shared_imports.Form, {
    form: form
  }, /*#__PURE__*/_react.default.createElement(_shared_imports.FormDataProvider, {
    pathsToWatch: "main"
  }, ({
    main
  }) => {
    const subOptions = getSubOptionsMeta(main);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "main",
      config: config,
      onChange: onMainValueChange
    }, field => renderSelect(field, options))), subOptions && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
      path: "sub",
      config: {
        ...config,
        defaultValue: subOptions.options[0].value,
        label: subOptions.label
      }
    }, field => renderSelect(field, subOptions.options))));
  }));
};
exports.AnalyzerParameterSelects = AnalyzerParameterSelects;