"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DocumentFieldsHeader = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _documentation = require("../../../../services/documentation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DocumentFieldsHeader = /*#__PURE__*/_react.default.memo(({
  searchValue,
  onSearchChange
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.idxMgmt.mappingsEditor.documentFieldsDescription",
    defaultMessage: "Define the fields for your indexed documents. {docsLink}",
    values: {
      docsLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: _documentation.documentationService.getMappingTypesLink(),
        target: "_blank",
        external: true
      }, _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.documentFieldsDocumentationLink', {
        defaultMessage: 'Learn more.'
      }))
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldSearch, {
    style: {
      minWidth: '350px'
    },
    placeholder: _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.documentFields.searchFieldsPlaceholder', {
      defaultMessage: 'Search fields'
    }),
    value: searchValue,
    onChange: e => {
      // Temporary fix until EUI fixes the contract
      // See my comment https://github.com/elastic/eui/pull/2723/files#r366725059
      if (typeof e === 'string') {
        onSearchChange(e);
      } else {
        onSearchChange(e.target.value);
      }
    },
    "aria-label": _i18n.i18n.translate('xpack.idxMgmt.mappingsEditor.documentFields.searchFieldsAriaLabel', {
      defaultMessage: 'Search mapped fields'
    })
  })));
});
exports.DocumentFieldsHeader = DocumentFieldsHeader;