"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBreadcrumbs = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getBreadcrumbs = setBreadcrumbs => {
  const baseBreadcrumbs = [{
    text: _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.breadcrumb.homeLabel', {
      defaultMessage: 'Index Management'
    }),
    href: '/'
  }, {
    text: _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.breadcrumb.componentTemplatesLabel', {
      defaultMessage: 'Component templates'
    }),
    href: '/component_templates'
  }];
  const setCreateBreadcrumbs = () => {
    const createBreadcrumbs = [...baseBreadcrumbs, {
      text: _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.breadcrumb.createComponentTemplateLabel', {
        defaultMessage: 'Create component template'
      })
    }];
    return setBreadcrumbs(createBreadcrumbs);
  };
  const setEditBreadcrumbs = () => {
    const editBreadcrumbs = [...baseBreadcrumbs, {
      text: _i18n.i18n.translate('xpack.idxMgmt.componentTemplate.breadcrumb.editComponentTemplateLabel', {
        defaultMessage: 'Edit component template'
      })
    }];
    return setBreadcrumbs(editBreadcrumbs);
  };
  return {
    setCreateBreadcrumbs,
    setEditBreadcrumbs
  };
};
exports.getBreadcrumbs = getBreadcrumbs;