"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.logisticsFormSchema = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _shared_imports = require("../../../shared_imports");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const {
  emptyField,
  containsCharsField,
  isJsonField
} = _shared_imports.fieldValidators;
const {
  toInt
} = _shared_imports.fieldFormatters;
const stringifyJson = json => Object.keys(json).length ? JSON.stringify(json, null, 2) : '{\n\n}';
const parseJson = jsonString => {
  let parsedJSON;
  try {
    parsedJSON = JSON.parse(jsonString);
  } catch {
    parsedJSON = {};
  }
  return parsedJSON;
};
const logisticsFormSchema = {
  name: {
    defaultValue: undefined,
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.nameFieldLabel', {
      defaultMessage: 'Name'
    }),
    type: _shared_imports.FIELD_TYPES.TEXT,
    validations: [{
      validator: emptyField(_i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.validation.nameRequiredError', {
        defaultMessage: 'A component template name is required.'
      }))
    }, {
      validator: containsCharsField({
        chars: ' ',
        message: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.validation.nameSpacesError', {
          defaultMessage: 'Spaces are not allowed in a component template name.'
        })
      })
    }]
  },
  version: {
    type: _shared_imports.FIELD_TYPES.NUMBER,
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.versionFieldLabel', {
      defaultMessage: 'Version (optional)'
    }),
    formatters: [toInt]
  },
  _meta: {
    label: _i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.metaFieldLabel', {
      defaultMessage: '_meta field data (optional)'
    }),
    helpText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.idxMgmt.componentTemplateForm.stepLogistics.metaHelpText",
      defaultMessage: "Use JSON format: {code}",
      values: {
        code: /*#__PURE__*/_react.default.createElement(_eui.EuiCode, null, JSON.stringify({
          arbitrary_data: 'anything_goes'
        }))
      }
    }),
    serializer: value => {
      const result = parseJson(value);
      // If an empty object was passed, strip out this value entirely.
      if (!Object.keys(result).length) {
        return undefined;
      }
      return result;
    },
    deserializer: stringifyJson,
    validations: [{
      validator: isJsonField(_i18n.i18n.translate('xpack.idxMgmt.componentTemplateForm.stepLogistics.validation.metaJsonError', {
        defaultMessage: 'The input is not valid.'
      }), {
        allowEmptyString: true
      })
    }]
  }
};
exports.logisticsFormSchema = logisticsFormSchema;