"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTable = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _analytics = require("@kbn/analytics");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../shared_imports");
var _constants = require("../constants");
var _component_templates_context = require("../component_templates_context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTable = ({
  componentTemplates,
  onReloadClick,
  onDeleteClick,
  onEditClick,
  onCloneClick,
  history
}) => {
  const {
    trackMetric
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  const [selection, setSelection] = (0, _react.useState)([]);
  const tableProps = {
    itemId: 'name',
    isSelectable: true,
    'data-test-subj': 'componentTemplatesTable',
    sorting: {
      sort: {
        field: 'name',
        direction: 'asc'
      }
    },
    selection: {
      onSelectionChange: setSelection,
      selectable: ({
        usedBy
      }) => usedBy.length === 0,
      selectableMessage: selectable => selectable ? _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.selectionLabel', {
        defaultMessage: 'Select this component template'
      }) : _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.disabledSelectionLabel', {
        defaultMessage: 'Component template is in use and cannot be deleted'
      })
    },
    rowProps: () => ({
      'data-test-subj': 'componentTemplateTableRow'
    }),
    search: {
      toolsLeft: selection.length > 0 ? /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        "data-test-subj": "deleteComponentTemplatexButton",
        onClick: () => onDeleteClick(selection.map(({
          name
        }) => name)),
        color: "danger"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesList.table.deleteComponentTemplatesButtonLabel",
        defaultMessage: "Delete {count, plural, one {component template} other {component templates} }",
        values: {
          count: selection.length
        }
      })) : undefined,
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "reloadButton",
        iconType: "refresh",
        color: "success",
        "data-test-subj": "reloadButton",
        onClick: onReloadClick
      }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.reloadButtonLabel', {
        defaultMessage: 'Reload'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({
        fill: true,
        iconType: "plusInCircle",
        "data-test-subj": "createPipelineButton",
        key: "createPipelineButton"
      }, (0, _shared_imports.reactRouterNavigate)(history, '/create_component_template')), _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.createButtonLabel', {
        defaultMessage: 'Create component template'
      }))],
      box: {
        incremental: true
      },
      filters: [{
        type: 'is',
        field: 'isManaged',
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.isManagedFilterLabel', {
          defaultMessage: 'Managed'
        })
      }, {
        type: 'field_value_toggle_group',
        field: 'usedBy.length',
        items: [{
          value: 1,
          name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.inUseFilterOptionLabel', {
            defaultMessage: 'In use'
          }),
          operator: 'gte'
        }, {
          value: 0,
          name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.notInUseFilterOptionLabel', {
            defaultMessage: 'Not in use'
          }),
          operator: 'eq'
        }]
      }]
    },
    pagination: {
      initialPageSize: 10,
      pageSizeOptions: [10, 20, 50]
    },
    columns: [{
      field: 'name',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.nameColumnTitle', {
        defaultMessage: 'Name'
      }),
      sortable: true,
      width: '20%',
      render: (name, item) => /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, (0, _extends2.default)({}, (0, _shared_imports.reactRouterNavigate)(history, {
        pathname: encodeURI(`/component_templates/${encodeURIComponent(name)}`)
      }, () => trackMetric(_analytics.METRIC_TYPE.CLICK, _constants.UIM_COMPONENT_TEMPLATE_DETAILS)), {
        "data-test-subj": "templateDetailsLink"
      }), name), item.isManaged && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
        color: "hollow",
        "data-test-subj": "isManagedBadge"
      }, _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.managedBadgeLabel', {
        defaultMessage: 'Managed'
      }))))
    }, {
      field: 'usedBy',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.isInUseColumnTitle', {
        defaultMessage: 'Usage count'
      }),
      sortable: ({
        usedBy
      }) => usedBy.length,
      render: usedBy => {
        if (usedBy.length) {
          return usedBy.length;
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "subdued"
        }, /*#__PURE__*/_react.default.createElement("i", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.idxMgmt.componentTemplatesList.table.notInUseCellDescription",
          defaultMessage: "Not in use"
        })));
      }
    }, {
      field: 'hasMappings',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.mappingsColumnTitle', {
        defaultMessage: 'Mappings'
      }),
      truncateText: true,
      sortable: true,
      render: hasMappings => hasMappings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }) : null
    }, {
      field: 'hasSettings',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.settingsColumnTitle', {
        defaultMessage: 'Settings'
      }),
      truncateText: true,
      sortable: true,
      render: hasSettings => hasSettings ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }) : null
    }, {
      field: 'hasAliases',
      name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.aliasesColumnTitle', {
        defaultMessage: 'Aliases'
      }),
      truncateText: true,
      sortable: true,
      render: hasAliases => hasAliases ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "check"
      }) : null
    }, {
      name: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.idxMgmt.componentTemplatesList.table.actionColumnTitle",
        defaultMessage: "Actions"
      }),
      actions: [{
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionEditText', {
          defaultMessage: 'Edit'
        }),
        description: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionEditDecription', {
          defaultMessage: 'Edit this component template'
        }),
        onClick: ({
          name
        }) => onEditClick(name),
        isPrimary: true,
        icon: 'pencil',
        type: 'icon',
        'data-test-subj': 'editComponentTemplateButton'
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionCloneText', {
          defaultMessage: 'Clone'
        }),
        description: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.actionCloneDecription', {
          defaultMessage: 'Clone this component template'
        }),
        onClick: ({
          name
        }) => onCloneClick(name),
        icon: 'copy',
        type: 'icon',
        'data-test-subj': 'cloneComponentTemplateButton'
      }, {
        name: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.deleteActionLabel', {
          defaultMessage: 'Delete'
        }),
        description: _i18n.i18n.translate('xpack.idxMgmt.componentTemplatesList.table.deleteActionDescription', {
          defaultMessage: 'Delete this component template'
        }),
        onClick: ({
          name
        }) => onDeleteClick([name]),
        enabled: ({
          usedBy
        }) => usedBy.length === 0,
        isPrimary: true,
        type: 'icon',
        icon: 'trash',
        color: 'danger',
        'data-test-subj': 'deleteComponentTemplateButton'
      }]
    }],
    items: componentTemplates !== null && componentTemplates !== void 0 ? componentTemplates : []
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, tableProps);
};
exports.ComponentTable = ComponentTable;