"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ComponentTemplateListContainer = void 0;
var _react = _interopRequireDefault(require("react"));
var _shared_imports = require("../shared_imports");
var _component_templates_context = require("../component_templates_context");
var _auth_provider = require("./auth_provider");
var _with_privileges = require("./with_privileges");
var _component_template_list = require("./component_template_list");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ComponentTemplateListContainer = ({
  match: {
    params: {
      componentTemplateName
    }
  },
  history
}) => {
  const {
    executionContext
  } = (0, _component_templates_context.useComponentTemplatesContext)();
  (0, _shared_imports.useExecutionContext)(executionContext, {
    type: 'application',
    page: 'indexManagementComponentTemplatesTab'
  });
  return /*#__PURE__*/_react.default.createElement(_auth_provider.ComponentTemplatesAuthProvider, null, /*#__PURE__*/_react.default.createElement(_with_privileges.ComponentTemplatesWithPrivileges, null, /*#__PURE__*/_react.default.createElement(_component_template_list.ComponentTemplateList, {
    componentTemplateName: componentTemplateName,
    history: history
  })));
};
exports.ComponentTemplateListContainer = ComponentTemplateListContainer;