"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AppWithoutRouter = exports.App = void 0;
var _react = _interopRequireWildcard(require("react"));
var _analytics = require("@kbn/analytics");
var _reactRouterDom = require("react-router-dom");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _constants = require("../../common/constants");
var _home = require("./sections/home");
var _template_create = require("./sections/template_create");
var _template_clone = require("./sections/template_clone");
var _template_edit = require("./sections/template_edit");
var _app_context = require("./app_context");
var _components = require("./components");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const App = ({
  history
}) => {
  const {
    services
  } = (0, _app_context.useAppContext)();
  (0, _react.useEffect)(() => services.uiMetricService.trackMetric(_analytics.METRIC_TYPE.LOADED, _constants.UIM_APP_LOAD), [services.uiMetricService]);
  return /*#__PURE__*/_react.default.createElement(_reactRouterDom.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(AppWithoutRouter, null));
};

// Export this so we can test it with a different router.
exports.App = App;
const AppWithoutRouter = () => /*#__PURE__*/_react.default.createElement(_reactRouterDom.Switch, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_template",
  component: _template_create.TemplateCreate
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/clone_template/:name*",
  component: _template_clone.TemplateClone
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/edit_template/:name*",
  component: _template_edit.TemplateEdit
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_component_template",
  component: _components.ComponentTemplateCreate
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/create_component_template/:sourceComponentTemplateName",
  component: _components.ComponentTemplateClone
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  exact: true,
  path: "/edit_component_template/:name*",
  component: _components.ComponentTemplateEdit
}), /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
  path: `/:section(${_home.homeSections.join('|')})`,
  component: _home.IndexManagementHome
}), /*#__PURE__*/_react.default.createElement(_reactRouterDom.Redirect, {
  from: `/`,
  to: `/indices`
}));
exports.AppWithoutRouter = AppWithoutRouter;