"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexLifecycleSummary = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _momentTimezone = _interopRequireDefault(require("moment-timezone"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _navigation = require("../../application/services/navigation");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHeaders = () => {
  return [['policy', _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.lifecyclePolicyHeader', {
    defaultMessage: 'Lifecycle policy'
  })], ['phase', _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentPhaseHeader', {
    defaultMessage: 'Current phase'
  })], ['action', _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionHeader', {
    defaultMessage: 'Current action'
  })], ['action_time_millis', _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.currentActionTimeHeader', {
    defaultMessage: 'Current action time'
  })], ['failed_step', _i18n.i18n.translate('xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.headers.failedStepHeader', {
    defaultMessage: 'Failed step'
  })]];
};
class IndexLifecycleSummary extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "toggleStackPopover", () => {
      this.setState({
        showStackPopover: !this.state.showStackPopover
      });
    });
    (0, _defineProperty2.default)(this, "closeStackPopover", () => {
      this.setState({
        showStackPopover: false
      });
    });
    (0, _defineProperty2.default)(this, "togglePhaseExecutionPopover", () => {
      this.setState({
        showPhaseExecutionPopover: !this.state.showPhaseExecutionPopover
      });
    });
    (0, _defineProperty2.default)(this, "closePhaseExecutionPopover", () => {
      this.setState({
        showPhaseExecutionPopover: false
      });
    });
    this.state = {
      showStackPopover: false,
      showPhaseExecutionPopover: false
    };
  }
  renderPhaseExecutionPopoverButton(ilm) {
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      onClick: this.togglePhaseExecutionPopover
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Show definition",
      id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.showPhaseDefinitionButton"
    }));
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      key: "phaseDefinition"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
      key: "phaseDefinition_title"
    }, /*#__PURE__*/_react.default.createElement("strong", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Phase definition",
      id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.showPhaseDefinitionDescriptionTitle"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
      key: "phaseDefinition_desc"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
      key: "phaseExecutionPopover",
      id: "phaseExecutionPopover",
      button: button,
      isOpen: this.state.showPhaseExecutionPopover,
      closePopover: this.closePhaseExecutionPopover
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPopoverTitle, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Phase definition",
      id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.phaseDefinitionTitle"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
      language: "json"
    }, JSON.stringify(ilm.phase_execution, null, 2)))));
  }
  buildRows() {
    const {
      index: {
        ilm
      }
    } = this.props;
    const headers = getHeaders();
    const rows = {
      left: [],
      right: []
    };
    headers.forEach(([fieldName, label], arrayIndex) => {
      const value = ilm[fieldName];
      let content;
      if (fieldName === 'action_time_millis') {
        content = (0, _momentTimezone.default)(value).format('YYYY-MM-DD HH:mm:ss');
      } else if (fieldName === 'policy') {
        content = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: this.props.getUrlForApp('management', {
            path: `data/index_lifecycle_management/${(0, _navigation.getPolicyEditPath)(value)}`
          })
        }, value);
      } else {
        content = value;
      }
      content = content || '-';
      const cell = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: String(arrayIndex)
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListTitle, {
        key: fieldName
      }, /*#__PURE__*/_react.default.createElement("strong", null, label)), /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionListDescription, {
        key: fieldName + '_desc'
      }, content));
      if (arrayIndex % 2 === 0) {
        rows.left.push(cell);
      } else {
        rows.right.push(cell);
      }
    });
    if (ilm.phase_execution) {
      rows.right.push(this.renderPhaseExecutionPopoverButton(ilm));
    }
    return rows;
  }
  render() {
    const {
      index: {
        ilm
      }
    } = this.props;
    if (!ilm.managed) {
      return null;
    }
    const {
      left,
      right
    } = this.buildRows();
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h3", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      defaultMessage: "Index lifecycle management",
      id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.summaryTitle"
    }))), ilm.step_info && ilm.step_info.type ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Index lifecycle error",
        id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.summaryErrorMessage"
      }),
      iconType: "cross"
    }, ilm.step_info.type, ": ", ilm.step_info.reason)) : null, ilm.step_info && ilm.step_info.message ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      color: "primary",
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        defaultMessage: "Action status",
        id: "xpack.indexLifecycleMgmt.indexLifecycleMgmtSummary.actionStatusTitle"
      })
    }, ilm.step_info.message)) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "column"
    }, left)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
      type: "column"
    }, right))));
  }
}
exports.IndexLifecycleSummary = IndexLifecycleSummary;