"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGlobalFields = exports.globalFields = exports.GlobalFieldsProvider = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GlobalFieldsContext = /*#__PURE__*/(0, _react.createContext)(null);
const globalFields = {
  deleteEnabled: {
    path: '_meta.delete.enabled'
  },
  searchableSnapshotRepo: {
    path: '_meta.searchableSnapshot.repository'
  },
  warmMinAgeMilliSeconds: {
    path: '_meta.warm.minAgeToMilliSeconds'
  },
  coldMinAgeMilliSeconds: {
    path: '_meta.cold.minAgeToMilliSeconds'
  },
  frozenMinAgeMilliSeconds: {
    path: '_meta.frozen.minAgeToMilliSeconds'
  },
  deleteMinAgeMilliSeconds: {
    path: '_meta.delete.minAgeToMilliSeconds'
  },
  hotIsUsingShardSize: {
    path: '_meta.hot.shrink.isUsingShardSize'
  },
  warmIsUsingShardSize: {
    path: '_meta.warm.shrink.isUsingShardSize'
  }
};
exports.globalFields = globalFields;
const GlobalFieldsProvider = ({
  children
}) => {
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseMultiFields, {
    fields: globalFields
  }, fields => {
    return /*#__PURE__*/_react.default.createElement(GlobalFieldsContext.Provider, {
      value: fields
    }, children);
  });
};
exports.GlobalFieldsProvider = GlobalFieldsProvider;
const useGlobalFields = () => {
  const ctx = (0, _react.useContext)(GlobalFieldsContext);
  if (!ctx) throw new Error('Cannot use global fields outside of global fields context');
  return ctx;
};
exports.useGlobalFields = useGlobalFields;