"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useConfiguration = exports.ConfigurationProvider = void 0;
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../shared_imports");
var _constants = require("../constants");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ConfigurationContext = /*#__PURE__*/(0, _react.createContext)(null);
const pathToHotPhaseSearchableSnapshot = 'phases.hot.actions.searchable_snapshot.snapshot_repository';
const pathToColdPhaseSearchableSnapshot = 'phases.cold.actions.searchable_snapshot.snapshot_repository';
const ConfigurationProvider = ({
  children
}) => {
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [pathToHotPhaseSearchableSnapshot, pathToColdPhaseSearchableSnapshot, _constants.isUsingCustomRolloverPath, _constants.isUsingDefaultRolloverPath, (0, _constants.isUsingDownsamplePath)('hot'), (0, _constants.isUsingDownsamplePath)('warm'), (0, _constants.isUsingDownsamplePath)('cold')]
  });
  const isUsingDefaultRollover = (0, _lodash.get)(formData, _constants.isUsingDefaultRolloverPath);
  // Provide default value, as path may become undefined if removed from the DOM
  const isUsingCustomRollover = (0, _lodash.get)(formData, _constants.isUsingCustomRolloverPath, true);
  const context = {
    isUsingRollover: isUsingDefaultRollover === false ? isUsingCustomRollover : true,
    isUsingSearchableSnapshotInHotPhase: (0, _lodash.get)(formData, pathToHotPhaseSearchableSnapshot) != null,
    isUsingSearchableSnapshotInColdPhase: (0, _lodash.get)(formData, pathToColdPhaseSearchableSnapshot) != null,
    isUsingDownsampleInHotPhase: !!(0, _lodash.get)(formData, (0, _constants.isUsingDownsamplePath)('hot')),
    isUsingDownsampleInWarmPhase: !!(0, _lodash.get)(formData, (0, _constants.isUsingDownsamplePath)('warm')),
    isUsingDownsampleInColdPhase: !!(0, _lodash.get)(formData, (0, _constants.isUsingDownsamplePath)('cold'))
  };
  return /*#__PURE__*/_react.default.createElement(ConfigurationContext.Provider, {
    value: context
  }, children);
};
exports.ConfigurationProvider = ConfigurationProvider;
const useConfiguration = () => {
  const ctx = (0, _react.useContext)(ConfigurationContext);
  if (!ctx) throw new Error('Cannot use configuration outside of configuration context');
  return ctx;
};
exports.useConfiguration = useConfiguration;