"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RepositoryComboBoxField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _shared_imports = require("../../../../../../../shared_imports");
var _form = require("../../../../form");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RepositoryComboBoxField = ({
  field,
  isLoading,
  repos,
  noSuggestions,
  globalRepository
}) => {
  const isMounted = (0, _react.useRef)(false);
  const {
    setValue
  } = field;
  const {
    searchableSnapshotRepo: {
      setValue: setSearchableSnapshotRepository
    }
  } = (0, _form.useGlobalFields)();
  (0, _react.useEffect)(() => {
    // We keep our phase searchable action field in sync
    // with the default repository field declared globally for the policy
    if (isMounted.current) {
      setValue(Boolean(globalRepository.trim()) ? [globalRepository] : []);
    }
    isMounted.current = true;
  }, [setValue, globalRepository]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.ComboBoxField, {
    field: field,
    fullWidth: false,
    euiFieldProps: {
      'data-test-subj': 'searchableSnapshotCombobox',
      options: repos.map(repo => ({
        label: repo,
        value: repo
      })),
      singleSelection: {
        asPlainText: true
      },
      isLoading,
      noSuggestions,
      onCreateOption: newOption => {
        setSearchableSnapshotRepository(newOption);
      },
      onChange: options => {
        if (options.length > 0) {
          setSearchableSnapshotRepository(options[0].label);
        } else {
          setSearchableSnapshotRepository('');
        }
      }
    }
  });
};
exports.RepositoryComboBoxField = RepositoryComboBoxField;