"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeAttrsDetails = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _api = require("../../../../../../../services/api");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const NodeAttrsDetails = ({
  close,
  selectedNodeAttrs
}) => {
  const {
    data,
    isLoading,
    error,
    resendRequest
  } = (0, _api.useLoadNodeDetails)(selectedNodeAttrs);
  let content;
  if (isLoading) {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingContent, {
      lines: 3
    });
  } else if (error) {
    const {
      statusCode,
      message
    } = error;
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
      title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.nodeDetailsLoadingFailedTitle",
        defaultMessage: "Unable to load node attribute details"
      }),
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement("p", null, message, " (", statusCode, ")"), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: resendRequest,
      iconType: "refresh",
      color: "danger"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.indexLifecycleMgmt.editPolicy.nodeDetailsReloadButton",
      defaultMessage: "Try again"
    })));
  } else {
    content = /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      items: data || [],
      columns: [{
        field: 'nodeId',
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.nodeAttrDetails.idField', {
          defaultMessage: 'ID'
        })
      }, {
        field: 'stats.name',
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.nodeAttrDetails.nameField', {
          defaultMessage: 'Name'
        })
      }, {
        field: 'stats.host',
        name: _i18n.i18n.translate('xpack.indexLifecycleMgmt.nodeAttrDetails.hostField', {
          defaultMessage: 'Host'
        })
      }],
      pagination: true,
      sorting: true
    });
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPortal, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyout, {
    ownFocus: true,
    onClose: close
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, null, /*#__PURE__*/_react.default.createElement("h2", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.nodeAttrDetails.title",
    defaultMessage: "Nodes that contain the attribute {selectedNodeAttrs}",
    values: {
      selectedNodeAttrs
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), content)));
};
exports.NodeAttrsDetails = NodeAttrsDetails;