"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.NodeAllocation = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _lodash = require("lodash");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _shared_imports = require("../../../../../../../../shared_imports");
var _form = require("../../../../../form");
var _learn_more_link = require("../../../../learn_more_link");
var _node_attrs_details = require("./node_attrs_details");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const i18nTexts = {
  allocateToDataNodesOption: _i18n.i18n.translate('xpack.indexLifecycleMgmt.editPolicy.nodeAllocation.allocateToDataNodesOption', {
    defaultMessage: 'Any data node'
  })
};
const NodeAllocation = ({
  phase,
  nodes,
  isLoading,
  isCloudEnabled,
  isUsingDeprecatedDataRoleConfig
}) => {
  const allocationNodeAttributePath = `_meta.${phase}.allocationNodeAttribute`;
  const [formData] = (0, _shared_imports.useFormData)({
    watch: [allocationNodeAttributePath]
  });
  const {
    docLinks
  } = (0, _shared_imports.useKibana)().services;
  const shardAllocationSettingsUrl = docLinks.links.elasticsearch.shardAllocationSettings;
  const selectedAllocationNodeAttribute = (0, _lodash.get)(formData, allocationNodeAttributePath);
  const [selectedNodeAttrsForDetails, setSelectedNodeAttrsForDetails] = (0, _react.useState)(null);
  const nodeOptions = Object.keys(nodes).map(attrs => ({
    text: `${attrs} (${nodes[attrs].length})`,
    value: attrs
  }));
  nodeOptions.sort((a, b) => a.value.localeCompare(b.value));
  let nodeAllocationOptions = [];

  // On Cloud, allocating to data tiers and allocating to data nodes is mutually exclusive. So we
  // only let users select this option if they're using data nodes. Otherwise we remove it.
  //
  // On prem, users should have the freedom to choose this option, even if they're using node roles.
  // So we always give them this option.
  if (!isCloudEnabled || isUsingDeprecatedDataRoleConfig) {
    const allocateToDataNodesOption = {
      text: i18nTexts.allocateToDataNodesOption,
      value: ''
    };
    nodeAllocationOptions.push(allocateToDataNodesOption);
  }
  nodeAllocationOptions = nodeAllocationOptions.concat(nodeOptions);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.indexLifecycleMgmt.editPolicy.nodeAllocation.customOption.description",
    defaultMessage: "Use node attributes to control shard allocation. {learnMoreLink}.",
    values: {
      learnMoreLink: /*#__PURE__*/_react.default.createElement(_learn_more_link.LearnMoreLink, {
        text: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.indexLifecycleMgmt.editPolicy.learnAboutShardAllocationLink",
          defaultMessage: "Learn about shard allocation"
        }),
        docPath: shardAllocationSettingsUrl
      })
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_form.UseField, {
    path: `_meta.${phase}.allocationNodeAttribute`,
    component: _shared_imports.SelectField,
    componentProps: {
      helpText: !!selectedAllocationNodeAttribute ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        size: "xs",
        style: {
          maxWidth: 400
        },
        "data-test-subj": `${phase}-viewNodeDetailsFlyoutButton`,
        flush: "left",
        onClick: () => setSelectedNodeAttrsForDetails(selectedAllocationNodeAttribute)
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.indexLifecycleMgmt.editPolicy.viewNodeDetailsButton",
        defaultMessage: "View nodes with the selected attribute"
      })) : undefined,
      euiFieldProps: {
        'data-test-subj': `${phase}-selectedNodeAttrs`,
        options: nodeAllocationOptions,
        hasNoInitialSelection: false,
        isLoading
      }
    }
  }), selectedNodeAttrsForDetails ? /*#__PURE__*/_react.default.createElement(_node_attrs_details.NodeAttrsDetails, {
    selectedNodeAttrs: selectedNodeAttrsForDetails,
    close: () => setSelectedNodeAttrsForDetails(null)
  }) : null);
};
exports.NodeAllocation = NodeAllocation;