"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageEmbeddablePlugin = void 0;
var _public = require("@kbn/kibana-utils-plugin/public");
var _image_embeddable = require("./image_embeddable");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

class ImageEmbeddablePlugin {
  constructor(context) {
    this.context = context;
  }
  setup(core, plugins) {
    const start = (0, _public.createStartServicesGetter)(core.getStartServices);
    plugins.embeddable.registerEmbeddableFactory(_image_embeddable.IMAGE_EMBEDDABLE_TYPE, new _image_embeddable.ImageEmbeddableFactoryDefinition({
      start: () => ({
        application: start().core.application,
        overlays: start().core.overlays,
        files: start().plugins.files.filesClientFactory.asUnscoped(),
        externalUrl: start().core.http.externalUrl,
        theme: start().core.theme,
        getUser: async () => {
          const security = start().plugins.security;
          return security ? await security.authc.getCurrentUser() : undefined;
        },
        uiActions: start().plugins.uiActions,
        isScreenshotMode: () => {
          var _plugins$screenshotMo, _plugins$screenshotMo2;
          return (_plugins$screenshotMo = (_plugins$screenshotMo2 = plugins.screenshotMode) === null || _plugins$screenshotMo2 === void 0 ? void 0 : _plugins$screenshotMo2.isScreenshotMode()) !== null && _plugins$screenshotMo !== void 0 ? _plugins$screenshotMo : false;
        }
      })
    }));
    plugins.uiActions.registerTrigger(_actions.imageClickTrigger);
    return {};
  }
  start(core, plugins) {
    return {};
  }
  stop() {}
}
exports.ImageEmbeddablePlugin = ImageEmbeddablePlugin;