"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ImageEmbeddableFactoryDefinition = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _i18n = require("@kbn/i18n");
var _imports = require("../imports");
var _image_embeddable = require("./image_embeddable");
var _validate_url = require("../utils/validate_url");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
class ImageEmbeddableFactoryDefinition {
  constructor(deps) {
    (0, _defineProperty2.default)(this, "type", _image_embeddable.IMAGE_EMBEDDABLE_TYPE);
    (0, _defineProperty2.default)(this, "getImageDownloadHref", fileId => this.deps.start().files.getDownloadHref({
      id: fileId,
      fileKind: _imports.imageEmbeddableFileKind.id
    }));
    this.deps = deps;
  }
  async isEditable() {
    var _this$deps$start$appl;
    return Boolean((_this$deps$start$appl = this.deps.start().application.capabilities.dashboard) === null || _this$deps$start$appl === void 0 ? void 0 : _this$deps$start$appl.showWriteControls);
  }
  async create(initialInput, parent) {
    return new _image_embeddable.ImageEmbeddable({
      getImageDownloadHref: this.getImageDownloadHref,
      validateUrl: (0, _validate_url.createValidateUrl)(this.deps.start().externalUrl),
      actions: {
        executeTriggerActions: (triggerId, context) => this.deps.start().uiActions.executeTriggerActions(triggerId, context),
        hasTriggerActions: (triggerId, context) => this.deps.start().uiActions.getTriggerCompatibleActions(triggerId, context).catch(() => []).then(actions => actions.length > 0)
      },
      isScreenshotMode: () => this.deps.start().isScreenshotMode()
    }, initialInput, parent);
  }
  getDisplayName() {
    return _i18n.i18n.translate('imageEmbeddable.imageEmbeddableFactory.displayName', {
      defaultMessage: 'Image'
    });
  }
  getIconType() {
    return `image`;
  }
  async getExplicitInput(initialInput) {
    const {
      configureImage
    } = await Promise.resolve().then(() => _interopRequireWildcard(require('../image_editor')));
    const start = this.deps.start();
    const {
      files,
      overlays,
      theme,
      application,
      externalUrl,
      getUser
    } = start;
    const user = await getUser();
    const imageConfig = await configureImage({
      files,
      overlays,
      theme,
      user,
      currentAppId$: application.currentAppId$,
      validateUrl: (0, _validate_url.createValidateUrl)(externalUrl),
      getImageDownloadHref: this.getImageDownloadHref
    }, initialInput ? initialInput.imageConfig : undefined);
    return {
      imageConfig
    };
  }
}
exports.ImageEmbeddableFactoryDefinition = ImageEmbeddableFactoryDefinition;