"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Introduction = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _content = require("./content");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

function IntroductionUI({
  description,
  previewUrl,
  title,
  exportedFieldsUrl,
  iconType,
  isBeta,
  intl,
  notices,
  basePath,
  category
}) {
  let rightSideItems;
  if (previewUrl) {
    rightSideItems = [/*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "l",
      allowFullScreen: true,
      fullScreenIconColor: "dark",
      alt: intl.formatMessage({
        id: 'home.tutorial.introduction.imageAltDescription',
        defaultMessage: 'screenshot of primary dashboard.'
      }),
      url: previewUrl
    })];
  }
  let exportedFields;
  if (exportedFieldsUrl) {
    exportedFields = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("br", null), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: exportedFieldsUrl,
      target: "_blank",
      rel: "noopener"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.tutorial.introduction.viewButtonLabel",
      defaultMessage: "View exported fields"
    })));
  }
  let betaBadge;
  if (isBeta) {
    betaBadge = /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
      label: intl.formatMessage({
        id: 'home.tutorial.introduction.betaLabel',
        defaultMessage: 'Beta'
      })
    });
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "arrowLeft",
    size: "xs",
    flush: "left",
    href: basePath.prepend(`/app/integrations`)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "home.tutorial.introduction.browseAllIntegrationsButton",
    defaultMessage: "Browse all integrations"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    iconType: iconType,
    pageTitle: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, title, betaBadge && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", betaBadge), category === _constants.TutorialsCategory.LOGGING || category === _constants.TutorialsCategory.METRICS ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, "\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.tutorial.introduction.beatsBadgeLabel",
      defaultMessage: "Beats"
    }))) : null),
    description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_content.Content, {
      text: description
    }), exportedFields, notices),
    rightSideItems: rightSideItems
  }));
}
IntroductionUI.propTypes = {
  description: _propTypes.default.string.isRequired,
  title: _propTypes.default.string.isRequired,
  previewUrl: _propTypes.default.string,
  exportedFieldsUrl: _propTypes.default.string,
  iconType: _propTypes.default.string,
  isBeta: _propTypes.default.bool,
  notices: _propTypes.default.node
};
IntroductionUI.defaultProps = {
  isBeta: false
};
const Introduction = (0, _i18nReact.injectI18n)(IntroductionUI);
exports.Introduction = Introduction;