"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SampleDataCard = SampleDataCard;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/*
 * The UI and related logic for the welcome screen that *should* show only
 * when it is enabled (the default) and there is no Kibana-consumed data
 * in Elasticsearch.
 */

function SampleDataCard({
  urlBasePath,
  onDecline,
  onConfirm
}) {
  const IS_DARK_THEME = (0, _kibana_services.getServices)().uiSettings.get('theme:darkMode');
  const cardGraphicFile = !IS_DARK_THEME ? 'illustration_integrations_lightmode.png' : 'illustration_integrations_darkmode.png';
  const cardGraphicURL = `${urlBasePath}/plugins/home/assets/common/${cardGraphicFile}`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    image: cardGraphicURL,
    textAlign: "left",
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.letsStartTitle",
      defaultMessage: "Start by adding integrations"
    }),
    description: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.letsStartDescription",
      defaultMessage: "Add data to your cluster from any source, then analyze and visualize it in real time. Use our solutions to add search anywhere, observe your ecosystem, and defend against security threats."
    }),
    footer: /*#__PURE__*/_react.default.createElement("footer", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      fill: true,
      className: "homWelcome__footerAction",
      onClick: onConfirm
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.tryButtonLabel",
      defaultMessage: "Add integrations"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      className: "homWelcome__footerAction",
      onClick: onDecline,
      "data-test-subj": "skipWelcomeScreen"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.exploreButtonLabel",
      defaultMessage: "Explore on my own"
    })))
  });
}