"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ManageData = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _app_navigation_handler = require("../app_navigation_handler");
var _synopsis = require("../synopsis");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const ManageData = ({
  addBasePath,
  application,
  features
}) => {
  var _share$url$locators$g, _share$url$locators$g2;
  const {
    share,
    trackUiMetric
  } = (0, _kibana_services.getServices)();
  const consoleHref = (_share$url$locators$g = share.url.locators.get('CONSOLE_APP_LOCATOR')) === null || _share$url$locators$g === void 0 ? void 0 : _share$url$locators$g.useUrl({});
  const managementHref = (_share$url$locators$g2 = share.url.locators.get('MANAGEMENT_APP_LOCATOR')) === null || _share$url$locators$g2 === void 0 ? void 0 : _share$url$locators$g2.useUrl({
    sectionId: ''
  });
  if (features.length) {
    const {
      management: isManagementEnabled,
      dev_tools: isDevToolsEnabled
    } = application.capabilities.navLinks;
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      bottomBorder: true,
      paddingSize: "xl",
      className: "homDataManage",
      "aria-labelledby": "homDataManage__title",
      "data-test-subj": "homDataManage"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "homDataManage__title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.manageData.sectionTitle",
      defaultMessage: "Management"
    })))), isDevToolsEnabled || isManagementEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "homDataManage__actions",
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      responsive: false,
      wrap: true
    }, isDevToolsEnabled && consoleHref !== undefined ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_public.RedirectAppLinks, {
      application: application
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "homeDevTools",
      className: "kbnOverviewPageHeader__actionButton",
      flush: "both",
      iconType: "wrench",
      href: consoleHref
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.manageData.devToolsButtonLabel",
      defaultMessage: "Dev Tools"
    })))) : null, isManagementEnabled ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_public.RedirectAppLinks, {
      application: application
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "homeManage",
      className: "kbnOverviewPageHeader__actionButton",
      flush: "both",
      iconType: "gear",
      href: managementHref
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.manageData.stackManagementButtonLabel",
      defaultMessage: "Stack Management"
    })))) : null)) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      className: "homDataManage__content"
    }, features.map(feature => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      className: "homDataManage__item",
      key: feature.id
    }, /*#__PURE__*/_react.default.createElement(_synopsis.Synopsis, {
      description: feature.description,
      iconType: feature.icon,
      id: feature.id,
      onClick: event => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, `manage_data_card_${feature.id}`);
        (0, _app_navigation_handler.createAppNavigationHandler)(feature.path)(event);
      },
      title: feature.title,
      url: addBasePath(feature.path)
    })))));
  } else {
    return null;
  }
};
exports.ManageData = ManageData;