"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddData = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18nReact = require("@kbn/i18n-react");
var _analytics = require("@kbn/analytics");
var _public = require("@kbn/kibana-react-plugin/public");
var _move_data = require("../move_data");
var _app_navigation_handler = require("../app_navigation_handler");
var _kibana_services = require("../../kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const AddData = ({
  addBasePath,
  application,
  isDarkMode,
  isCloudEnabled
}) => {
  const {
    trackUiMetric,
    guidedOnboardingService
  } = (0, _kibana_services.getServices)();
  const canAccessIntegrations = application.capabilities.navLinks.integrations;
  if (canAccessIntegrations) {
    return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
      bottomBorder: true,
      paddingSize: "xl",
      className: "homDataAdd",
      "aria-labelledby": "homDataAdd__title"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement("h2", {
      id: "homDataAdd__title"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.sectionTitle",
      defaultMessage: "Get started by adding integrations"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.text",
      defaultMessage: "To start working with your data, use one of our many ingest options. Collect data from an app or service, or upload a file. If you're not ready to use your own data, play with a sample data set."
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m"
    }, (guidedOnboardingService === null || guidedOnboardingService === void 0 ? void 0 : guidedOnboardingService.isEnabled) && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "guidedOnboardingLink",
      fill: true,
      href: addBasePath('#/getting_started'),
      onClick: event => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'guided_onboarding_link');
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.guidedOnboardingLinkLabel",
      defaultMessage: "Setup guides"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_public.RedirectAppLinks, {
      application: application
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "homeAddData"
      // when guided onboarding is disabled, this button is primary
      // otherwise it's secondary, because there is a "guided onboarding" button
      ,
      fill: !(guidedOnboardingService !== null && guidedOnboardingService !== void 0 && guidedOnboardingService.isEnabled),
      href: addBasePath('/app/integrations/browse'),
      iconType: "plusInCircle",
      onClick: event => {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, 'home_tutorial_directory');
        (0, _app_navigation_handler.createAppNavigationHandler)('/app/integrations/browse')(event);
      },
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.addDataButtonLabel",
      defaultMessage: "Add integrations"
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "addSampleData",
      href: addBasePath('#/tutorial_directory/sampleData'),
      iconType: "documents"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.sampleDataButtonLabel",
      defaultMessage: "Try sample data"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "uploadFile",
      href: addBasePath('#/tutorial_directory/fileDataViz'),
      iconType: "importAction"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "home.addData.uploadFileButtonLabel",
      defaultMessage: "Upload a file"
    }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, !isCloudEnabled ? /*#__PURE__*/_react.default.createElement(_move_data.MoveData, {
      addBasePath: addBasePath
    }) : /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      alt: _i18n.i18n.translate('home.addData.illustration.alt.text', {
        defaultMessage: 'Illustration of Elastic data integrations'
      }),
      className: "homDataAdd__illustration",
      src: addBasePath('/plugins/kibanaReact/assets/') + (isDarkMode ? 'illustration_integrations_darkmode.svg' : 'illustration_integrations_lightmode.svg')
    }))));
  } else {
    return null;
  }
};
exports.AddData = AddData;