"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QuitGuideModal = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _api = require("../services/api.service");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const QuitGuideModal = ({
  closeModal,
  currentGuide,
  telemetryGuideId,
  notifications
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const deactivateGuide = async () => {
    try {
      setIsLoading(true);
      await _api.apiService.deactivateGuide(currentGuide);
      closeModal();
    } catch (error) {
      setIsLoading(false);
      notifications.toasts.addDanger({
        title: _i18n.i18n.translate('guidedOnboarding.quitGuideModal.deactivateGuideError', {
          defaultMessage: 'Unable to update the guide. Wait a moment and try again.'
        }),
        text: error.message
      });
    }
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
    "aria-label": "quitGuideModal",
    "data-test-subj": "onboarding--quitGuideModal",
    maxWidth: 448,
    onClose: closeModal
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, null, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.modalTitle', {
    defaultMessage: 'Quit this guide?'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.modalDescription', {
    defaultMessage: 'You can restart the setup guide any time from the Help menu.'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    "data-test-subj": `onboarding--cancelQuitGuideButton--${telemetryGuideId}`,
    onClick: closeModal
  }, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.cancelButtonLabel', {
    defaultMessage: 'Cancel'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton
  // Used for FS tracking and tests
  , {
    "data-test-subj": `onboarding--quitGuideButton--${telemetryGuideId}`,
    onClick: deactivateGuide,
    isLoading: isLoading,
    fill: true,
    color: "warning"
  }, _i18n.i18n.translate('guidedOnboarding.quitGuideModal.quitButtonLabel', {
    defaultMessage: 'Quit guide'
  }))));
};
exports.QuitGuideModal = QuitGuideModal;