"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GuidePanelFlyoutBody = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _well_done_animated_dark = _interopRequireDefault(require("../../../assets/well_done_animated_dark.gif"));
var _guide_progress = require("./guide_progress");
var _well_done_animated = _interopRequireDefault(require("../../../assets/well_done_animated.gif"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

const GuidePanelFlyoutBody = ({
  styles,
  guideConfig,
  isDarkTheme,
  stepsCompleted,
  isGuideReadyToComplete,
  pluginState,
  handleStepButtonClick,
  isLoading,
  completeGuide
}) => {
  const docsLink = () => {
    if (!guideConfig || !guideConfig.docs) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "l"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      external: true,
      target: "_blank",
      href: guideConfig.docs.url
    }, guideConfig.docs.text)));
  };
  if (!guideConfig || !pluginState || pluginState && pluginState.status === 'error') {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      "data-test-subj": "guideErrorSection",
      iconType: "alert",
      color: "danger",
      title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.errorSectionTitle', {
        defaultMessage: 'Unable to load the guide'
      })),
      body: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued"
      }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.errorSectionDescription', {
        defaultMessage: `Wait a moment and try again. If the problem persists, contact your administrator.`
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        iconSide: "right",
        onClick: () => window.location.reload(),
        iconType: "refresh",
        color: "danger"
      }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.errorSectionReloadButton', {
        defaultMessage: 'Reload'
      })))
    });
  }
  if (isGuideReadyToComplete) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
      size: "fullWidth",
      src: isDarkTheme ? _well_done_animated_dark.default : _well_done_animated.default,
      alt: _i18n.i18n.translate('guidedOnboarding.dropdownPanel.wellDoneAnimatedGif', {
        defaultMessage: `Guide completed animated gif`
      })
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "m"
    }, /*#__PURE__*/_react.default.createElement("p", {
      "data-test-subj": "guideDescription"
    }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.completeGuideFlyoutDescription', {
      defaultMessage: `You've completed the Elastic {guideName} guide. Feel free to come back to the Guides for more onboarding help or a refresher.`,
      values: {
        guideName: guideConfig.guideName
      }
    }))), docsLink(), /*#__PURE__*/_react.default.createElement(_guide_progress.GuideProgress, {
      guideConfig: guideConfig,
      styles: styles,
      pluginState: pluginState,
      isLoading: isLoading,
      handleStepButtonClick: handleStepButtonClick,
      isGuideReadyToComplete: isGuideReadyToComplete,
      stepsCompleted: stepsCompleted
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      isLoading: isLoading,
      onClick: () => completeGuide(guideConfig.completedGuideRedirectLocation),
      fill: true
      // data-test-subj used for FS tracking and testing
      ,
      "data-test-subj": `onboarding--completeGuideButton--${guideConfig.telemetryId}`
    }, _i18n.i18n.translate('guidedOnboarding.dropdownPanel.elasticButtonLabel', {
      defaultMessage: 'Continue using Elastic'
    })))));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "m"
  }, /*#__PURE__*/_react.default.createElement("p", {
    "data-test-subj": "guideDescription"
  }, guideConfig.description)), docsLink(), /*#__PURE__*/_react.default.createElement(_guide_progress.GuideProgress, {
    guideConfig: guideConfig,
    styles: styles,
    pluginState: pluginState,
    isLoading: isLoading,
    handleStepButtonClick: handleStepButtonClick,
    isGuideReadyToComplete: isGuideReadyToComplete,
    stepsCompleted: stepsCompleted
  })));
};
exports.GuidePanelFlyoutBody = GuidePanelFlyoutBody;