"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getGuidePanelStyles = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _panel_bg_top = _interopRequireDefault(require("../../assets/panel_bg_top.svg"));
var _panel_bg_top_dark = _interopRequireDefault(require("../../assets/panel_bg_top_dark.svg"));
var _panel_bg_bottom = _interopRequireDefault(require("../../assets/panel_bg_bottom.svg"));
var _panel_bg_bottom_dark = _interopRequireDefault(require("../../assets/panel_bg_bottom_dark.svg"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

/**
 *
 * Style overrides for the setup guide dropdown panel.
 * There is currently no existing EUI component that fully supports what we need.
 * In order to leverage a11y features, we are using the EuiFlyout and applying customizations
 * See https://github.com/elastic/eui/issues/6241 for more details
 */
const getGuidePanelStyles = ({
  euiThemeContext,
  isDarkTheme
}) => {
  const euiTheme = euiThemeContext.euiTheme;
  const flyoutContainerBase = (0, _react.css)`
    position: fixed;
    height: 100%;
    max-height: 76vh;
    max-inline-size: 480px;
    max-block-size: auto;
    inset-inline-end: 0;
    inset-block-start: ${euiTheme.size.xxxl};
    ${_eui.euiCanAnimate} {
      animation: ${_eui.euiFlyoutSlideInRight} ${euiTheme.animation.normal}
        ${euiTheme.animation.resistance};
    }
    @media (min-width: ${euiTheme.breakpoint.m}px) {
      right: calc(${euiTheme.size.s} + 128px); // Accounting for margin on button
    })
  `;
  return {
    setupButton: (0, _react.css)`
      margin-right: ${euiTheme.size.m};
    `,
    wellDoneAnimatedPrompt: (0, _react.css)`
      text-align: left;
    `,
    flyoutOverrides: {
      flyoutContainer: (0, _react.css)`
        ${flyoutContainerBase};
        background: ${euiTheme.colors.emptyShade} url(${isDarkTheme ? _panel_bg_top_dark.default : _panel_bg_top.default})
          top right no-repeat;
        padding: 0;
      `,
      flyoutContainerError: (0, _react.css)`
        ${flyoutContainerBase};
        padding: 24px;
      `,
      flyoutHeader: (0, _react.css)`
        flex-grow: 0;
        padding: 16px 16px 0;
      `,
      flyoutHeaderError: (0, _react.css)`
        flex-grow: 0;
        padding: 8px 0 0;
      `,
      flyoutContentWrapper: (0, _react.css)`
        display: flex;
        block-size: 100%;
        justify-content: space-between;
        flex-direction: column;
      `,
      flyoutCloseButtonIcon: (0, _react.css)`
        position: absolute;
        inset-block-start: ${euiTheme.size.base};
        inset-inline-end: ${euiTheme.size.base};
      `,
      flyoutBodyWrapper: (0, _react.css)`
        ${(0, _eui.logicalCSS)('height', '100%')}
        ${(0, _eui.logicalCSSWithFallback)('overflow-y', 'hidden')}
      flex-grow: 1;
      `,
      flyoutBody: (0, _react.css)`
        ${(0, _eui.euiYScrollWithShadows)(euiThemeContext, {
        side: 'end'
      })}
        padding: 16px 10px 0 16px;
      `,
      flyoutBodyError: (0, _react.css)`
        height: 600px;
      `,
      flyoutStepsWrapper: (0, _react.css)`
        > li {
          list-style-type: none;
        }
        margin-inline-start: 0 !important;
      `,
      flyoutFooter: (0, _react.css)`
        border-radius: 0 0 6px 6px;
        background: url(${isDarkTheme ? _panel_bg_bottom_dark.default : _panel_bg_bottom.default}) 0 36px no-repeat;
        padding: 24px 30px;
        height: 125px;
        flex-grow: 0;
      `,
      flyoutFooterLink: (0, _react.css)`
        color: ${euiTheme.colors.darkShade};
        font-weight: 400;
      `
    }
  };
};
exports.getGuidePanelStyles = getGuidePanelStyles;