"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = renderApp;
var _react = _interopRequireDefault(require("react"));
var _reactDom = require("react-dom");
var _i18nReact = require("@kbn/i18n-react");
var _shared_imports = require("./shared_imports");
var _grok_debugger = require("./components/grok_debugger");
var _grokdebugger_service = require("./services/grokdebugger/grokdebugger_service");
var _inactive_license = require("./components/inactive_license");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function renderApp(license, element, coreStart, theme$) {
  const content = license.isActive ? /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaContextProvider, {
    services: {
      ...coreStart
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_grok_debugger.GrokDebugger, {
    grokdebuggerService: new _grokdebugger_service.GrokdebuggerService(coreStart.http)
  })))) : /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_shared_imports.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_inactive_license.InactiveLicenseSlate, {
    license: license
  })));
  (0, _reactDom.render)(content, element);
  return () => (0, _reactDom.unmountComponentAtNode)(element);
}