"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.openSourceModal = openSourceModal;
var _react = _interopRequireDefault(require("react"));
var _source_modal = require("../components/source_modal");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function openSourceModal({
  overlays,
  http,
  uiSettings,
  savedObjectsManagement
}, onSelected) {
  const modalRef = overlays.openModal( /*#__PURE__*/_react.default.createElement(_source_modal.SourceModal, {
    http: http,
    uiSettings: uiSettings,
    savedObjectsManagement: savedObjectsManagement,
    onIndexPatternSelected: indexPattern => {
      onSelected(indexPattern);
      modalRef.close();
    }
  }));
}