"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UrlTemplateList = UrlTemplateList;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _url_template_form = require("./url_template_form");
var _use_list_keys = require("./use_list_keys");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateId = (0, _eui.htmlIdGenerator)();
function UrlTemplateList({
  removeTemplate,
  saveTemplate,
  urlTemplates
}) {
  const [uncommittedForms, setUncommittedForms] = (0, _react.useState)([]);
  const getListKey = (0, _use_list_keys.useListKeys)(urlTemplates);
  function removeUncommittedForm(id) {
    setUncommittedForms(uncommittedForms.filter(formId => formId !== id));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, _i18n.i18n.translate('xpack.graph.drilldowns.description', {
    defaultMessage: 'Use drilldowns to link to other applications. The selected vertices become part of the URL.'
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), urlTemplates.map((template, index) => /*#__PURE__*/_react.default.createElement(_url_template_form.UrlTemplateForm, {
    key: getListKey(template),
    id: getListKey(template),
    initialTemplate: template,
    onSubmit: newTemplate => {
      saveTemplate({
        index,
        template: newTemplate
      });
    },
    onRemove: () => {
      removeTemplate(template);
    }
  })), uncommittedForms.map(id => /*#__PURE__*/_react.default.createElement(_url_template_form.UrlTemplateForm, {
    id: `accordion-new-${id}`,
    key: id,
    onSubmit: newTemplate => {
      saveTemplate({
        index: -1,
        template: newTemplate
      });
      removeUncommittedForm(id);
    },
    onRemove: removeUncommittedForm.bind(undefined, id)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiTextAlign, {
    textAlign: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    size: "s",
    fill: true,
    iconType: "plusInCircle",
    "data-test-subj": "graphAddNewTemplate",
    onClick: () => {
      setUncommittedForms([...uncommittedForms, generateId()]);
    }
  }, _i18n.i18n.translate('xpack.graph.templates.newTemplateFormLabel', {
    defaultMessage: 'Add drilldown'
  }))));
}