"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AdvancedSettingsForm = AdvancedSettingsForm;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AdvancedSettingsForm({
  advancedSettings,
  updateSettings,
  allFields
}) {
  // keep a local state during changes
  const [formState, updateFormState] = (0, _react.useState)({
    ...advancedSettings
  });

  // useEffect update localState only based on the main store
  (0, _react.useEffect)(() => {
    updateFormState(advancedSettings);
  }, [updateFormState, advancedSettings]);
  function updateSetting(key, value) {
    updateSettings({
      ...advancedSettings,
      [key]: value
    });
  }
  function getNumberUpdater(key) {
    return function ({
      target: {
        valueAsNumber,
        value
      }
    }) {
      // if the value is valid, then update the central store, otherwise only the local store
      if (Number.isNaN(valueAsNumber)) {
        // localstate update
        return updateFormState({
          ...formState,
          [key]: value
        });
      }
      // do not worry about local store here, the useEffect will pick that up and sync it
      updateSetting(key, valueAsNumber);
    };
  }
  return /*#__PURE__*/_react.default.createElement("form", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.sampleSizeInputHelpText', {
      defaultMessage: 'Terms are identified from samples of the most relevant documents. Bigger samples are not necessarily better—they can be slower and less relevant.'
    }),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.sampleSizeInputLabel', {
      defaultMessage: 'Sample size'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.sampleSize,
    onChange: getNumberUpdater('sampleSize')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.significantLinksCheckboxHelpText', {
      defaultMessage: 'Identify terms that are significant rather than popular.'
    }),
    label: ""
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.significantLinksCheckboxLabel', {
      defaultMessage: 'Significant links'
    }),
    id: "graphSignificance",
    checked: formState.useSignificance,
    onChange: ({
      target: {
        checked
      }
    }) => updateSetting('useSignificance', checked)
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.certaintyInputHelpText', {
      defaultMessage: 'The minimum number of documents before introducing a related term.'
    }),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.certaintyInputLabel', {
      defaultMessage: 'Certainty'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.minDocCount,
    onChange: getNumberUpdater('minDocCount')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputHelpText1', {
      defaultMessage: 'To avoid dominating samples with a single voice, select a field to help identify the source of bias.'
    }), ' ', /*#__PURE__*/_react.default.createElement("em", null, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputHelpText2', {
      defaultMessage: 'This must be a single-term field, or searches will be rejected.'
    }))),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputLabel', {
      defaultMessage: 'Diversity field'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    fullWidth: true,
    placeholder: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.diversityFieldInputOptionLabel', {
      defaultMessage: 'No diversification'
    }),
    singleSelection: {
      asPlainText: true
    },
    options: allFields.map(field => ({
      label: field.name,
      value: field
    })),
    selectedOptions: formState.sampleDiversityField ? [{
      label: formState.sampleDiversityField.name,
      value: formState.sampleDiversityField
    }] : [],
    onChange: choices => {
      updateSetting('sampleDiversityField', choices.length === 1 ? choices[0].value : undefined);
    }
  })), formState.sampleDiversityField && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.maxValuesInputHelpText', {
      defaultMessage: 'Max number of documents in a sample that can contain the same value for the'
    }), ' ', /*#__PURE__*/_react.default.createElement("em", null, formState.sampleDiversityField.name), ' ', _i18n.i18n.translate('xpack.graph.settings.advancedSettings.maxValuesInputHelpText.fieldText', {
      defaultMessage: 'field'
    })),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.maxValuesInputLabel', {
      defaultMessage: 'Max docs per field'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.maxValuesPerDoc,
    onChange: getNumberUpdater('maxValuesPerDoc')
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    helpText: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.timeoutInputHelpText', {
      defaultMessage: 'The maximum number of milliseconds that a request can run.'
    }),
    label: _i18n.i18n.translate('xpack.graph.settings.advancedSettings.timeoutInputLabel', {
      defaultMessage: 'Timeout'
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldNumber, {
    fullWidth: true,
    min: 1,
    step: 1,
    value: formState.timeoutMillis,
    onChange: getNumberUpdater('timeoutMillis'),
    append: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("strong", null, _i18n.i18n.translate('xpack.graph.settings.advancedSettings.timeoutUnit', {
      defaultMessage: 'ms'
    })))
  })));
}