"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SelectedNodeItem = void 0;
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _react = _interopRequireDefault(require("react"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isHexColorDark = color => (0, _eui.isColorDark)(...(0, _eui.hexToRgb)(color));
const SelectedNodeItem = ({
  node,
  isHighlighted,
  onSelectedFieldClick,
  onDeselectNode
}) => {
  const fieldClasses = (0, _classnames.default)('gphSelectionList__field', {
    ['gphSelectionList__field--selected']: isHighlighted
  });
  const fieldIconClasses = (0, _classnames.default)('fa', 'gphNode__text', 'gphSelectionList__icon', {
    ['gphNode__text--inverse']: isHexColorDark(node.color)
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    "aria-hidden": "true",
    className: fieldClasses,
    onClick: () => onSelectedFieldClick(node)
  }, /*#__PURE__*/_react.default.createElement("svg", {
    width: "24",
    height: "24"
  }, /*#__PURE__*/_react.default.createElement("circle", {
    className: "gphNode__circle",
    r: "10",
    cx: "12",
    cy: "12",
    style: {
      fill: node.color
    },
    onClick: () => onDeselectNode(node)
  }), node.icon && /*#__PURE__*/_react.default.createElement("text", {
    className: fieldIconClasses,
    textAnchor: "middle",
    x: "12",
    y: "16",
    onClick: () => onDeselectNode(node)
  }, node.icon.code)), /*#__PURE__*/_react.default.createElement("span", null, node.label), node.numChildren > 0 && /*#__PURE__*/_react.default.createElement("span", null, " (+", node.numChildren, ")"));
};
exports.SelectedNodeItem = SelectedNodeItem;