"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DrillDowns = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DrillDowns = ({
  urlTemplates,
  openUrlTemplate
}) => {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSidebar__header"
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "kuiIcon fa-info"
  }), _i18n.i18n.translate('xpack.graph.sidebar.drillDownsTitle', {
    defaultMessage: 'Drill-downs'
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "gphSidebar__panel"
  }, urlTemplates.length === 0 && /*#__PURE__*/_react.default.createElement("p", {
    className: "help-block"
  }, _i18n.i18n.translate('xpack.graph.sidebar.drillDowns.noDrillDownsHelpText', {
    defaultMessage: 'Configure drill-downs from the settings menu'
  })), /*#__PURE__*/_react.default.createElement("ul", {
    className: "list-group"
  }, urlTemplates.map(urlTemplate => {
    var _urlTemplate$icon;
    const onOpenUrlTemplate = () => openUrlTemplate(urlTemplate);
    return /*#__PURE__*/_react.default.createElement("li", {
      className: "list-group-item"
    }, urlTemplate.icon && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("span", {
      className: "kuiIcon gphNoUserSelect"
    }, (_urlTemplate$icon = urlTemplate.icon) === null || _urlTemplate$icon === void 0 ? void 0 : _urlTemplate$icon.code), ' '), /*#__PURE__*/_react.default.createElement("a", {
      "aria-hidden": "true",
      onClick: onOpenUrlTemplate
    }, urlTemplate.description));
  }))));
};
exports.DrillDowns = DrillDowns;