"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkspaceRoute = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _reactRedux = require("react-redux");
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/kibana-react-plugin/public");
var _state_management = require("../state_management");
var _graph_client_workspace = require("../services/workspace/graph_client_workspace");
var _workspace_layout = require("../components/workspace_layout");
var _use_workspace_loader = require("../helpers/use_workspace_loader");
var _use_graph_loader = require("../helpers/use_graph_loader");
var _index_pattern_cache = require("../services/index_pattern_cache");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const WorkspaceRoute = ({
  deps: {
    toastNotifications,
    coreStart,
    savedObjectsClient,
    graphSavePolicy,
    chrome,
    canEditDrillDownUrls,
    overlays,
    navigation,
    capabilities,
    storage,
    data,
    unifiedSearch,
    getBasePath,
    addBasePath,
    setHeaderActionMenu,
    spaces,
    indexPatterns: getIndexPatternProvider,
    inspect,
    savedObjectsManagement
  }
}) => {
  /**
   * It's temporary workaround, which should be removed after migration `workspace` to redux.
   * Ref holds mutable `workspace` object. After each `workspace.methodName(...)` call
   * (which might mutate `workspace` somehow), react state needs to be updated using
   * `workspace.changeHandler()`.
   */
  const workspaceRef = (0, _react.useRef)();
  /**
   * Providing `workspaceRef.current` to the hook dependencies or components itself
   * will not leads to updates, therefore `renderCounter` is used to update react state.
   */
  const [renderCounter, setRenderCounter] = (0, _react.useState)(0);
  const history = (0, _reactRouterDom.useHistory)();
  const indexPatternProvider = (0, _react.useMemo)(() => (0, _index_pattern_cache.createCachedIndexPatternProvider)(getIndexPatternProvider.get), [getIndexPatternProvider.get]);
  const services = (0, _react.useMemo)(() => ({
    appName: 'graph',
    storage,
    data,
    unifiedSearch,
    savedObjectsManagement,
    ...coreStart
  }), [coreStart, data, storage, unifiedSearch, savedObjectsManagement]);
  const {
    loading,
    requestAdapter,
    callNodeProxy,
    callSearchNodeProxy,
    handleSearchQueryError
  } = (0, _use_graph_loader.useGraphLoader)({
    toastNotifications,
    coreStart
  });
  const [store] = (0, _react.useState)(() => (0, _state_management.createGraphStore)({
    basePath: getBasePath(),
    addBasePath,
    indexPatternProvider,
    createWorkspace: (indexPattern, exploreControls) => {
      const options = {
        indexName: indexPattern,
        vertex_fields: [],
        // Here we have the opportunity to look up labels for nodes...
        nodeLabeller() {
          // console.log(newNodes);
        },
        changeHandler: () => setRenderCounter(cur => cur + 1),
        graphExploreProxy: callNodeProxy,
        searchProxy: callSearchNodeProxy,
        exploreControls
      };
      const createdWorkspace = workspaceRef.current = (0, _graph_client_workspace.createWorkspace)(options);
      return createdWorkspace;
    },
    getWorkspace: () => workspaceRef.current,
    notifications: coreStart.notifications,
    http: coreStart.http,
    overlays: coreStart.overlays,
    savedObjectsClient,
    savePolicy: graphSavePolicy,
    changeUrl: newUrl => history.push(newUrl),
    notifyReact: () => setRenderCounter(cur => cur + 1),
    chrome,
    handleSearchQueryError
  }));
  const loaded = (0, _use_workspace_loader.useWorkspaceLoader)({
    workspaceRef,
    store,
    savedObjectsClient,
    spaces,
    coreStart,
    data
  });
  if (!loaded) {
    return null;
  }
  const {
    savedWorkspace,
    sharingSavedObjectProps
  } = loaded;
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_public.KibanaContextProvider, {
    services: services
  }, /*#__PURE__*/_react.default.createElement(_reactRedux.Provider, {
    store: store
  }, /*#__PURE__*/_react.default.createElement(_workspace_layout.WorkspaceLayout, {
    spaces: spaces,
    sharingSavedObjectProps: sharingSavedObjectProps,
    renderCounter: renderCounter,
    workspace: workspaceRef.current,
    loading: loading,
    setHeaderActionMenu: setHeaderActionMenu,
    graphSavePolicy: graphSavePolicy,
    navigation: navigation,
    capabilities: capabilities,
    coreStart: coreStart,
    canEditDrillDownUrls: canEditDrillDownUrls,
    overlays: overlays,
    savedWorkspace: savedWorkspace,
    indexPatternProvider: indexPatternProvider,
    inspect: inspect,
    requestAdapter: requestAdapter
  }))));
};
exports.WorkspaceRoute = WorkspaceRoute;