"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ListingRoute = ListingRoute;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _reactRouterDom = require("react-router-dom");
var _contentManagementTableList = require("@kbn/content-management-table-list");
var _saved_workspace_utils = require("../helpers/saved_workspace_utils");
var _url = require("../services/url");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SAVED_OBJECTS_LIMIT_SETTING = 'savedObjects:listingLimit';
const SAVED_OBJECTS_PER_PAGE_SETTING = 'savedObjects:perPage';
const toTableListViewSavedObject = savedObject => {
  var _savedObject$referenc;
  return {
    id: savedObject.id,
    updatedAt: savedObject.updatedAt,
    references: (_savedObject$referenc = savedObject.references) !== null && _savedObject$referenc !== void 0 ? _savedObject$referenc : [],
    type: savedObject.type,
    attributes: {
      title: savedObject.title,
      description: savedObject.description
    }
  };
};
function ListingRoute({
  deps: {
    chrome,
    savedObjectsClient,
    coreStart,
    capabilities,
    addBasePath,
    uiSettings
  }
}) {
  const listingLimit = uiSettings.get(SAVED_OBJECTS_LIMIT_SETTING);
  const initialPageSize = uiSettings.get(SAVED_OBJECTS_PER_PAGE_SETTING);
  const history = (0, _reactRouterDom.useHistory)();
  const query = new URLSearchParams((0, _reactRouterDom.useLocation)().search);
  const initialFilter = query.get('filter') || '';
  (0, _react.useEffect)(() => {
    (0, _url.setBreadcrumbs)({
      chrome
    });
  }, [chrome]);
  const createItem = (0, _react.useCallback)(() => {
    history.push((0, _url.getNewPath)());
  }, [history]);
  const findItems = (0, _react.useCallback)(search => {
    return (0, _saved_workspace_utils.findSavedWorkspace)({
      savedObjectsClient,
      basePath: coreStart.http.basePath
    }, search, listingLimit).then(({
      total,
      hits
    }) => ({
      total,
      hits: hits.map(toTableListViewSavedObject)
    }));
  }, [coreStart.http.basePath, listingLimit, savedObjectsClient]);
  const editItem = (0, _react.useCallback)(savedWorkspace => {
    history.push((0, _url.getEditPath)(savedWorkspace));
  }, [history]);
  const deleteItems = (0, _react.useCallback)(async savedWorkspaces => {
    await (0, _saved_workspace_utils.deleteSavedWorkspace)(savedObjectsClient, savedWorkspaces.map(cur => cur.id));
  }, [savedObjectsClient]);
  return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_contentManagementTableList.TableListView, {
    id: "graph",
    headingId: "graphListingHeading",
    createItem: capabilities.graph.save ? createItem : undefined,
    findItems: findItems,
    deleteItems: capabilities.graph.delete ? deleteItems : undefined,
    editItem: capabilities.graph.save ? editItem : undefined,
    listingLimit: listingLimit,
    initialFilter: initialFilter,
    initialPageSize: initialPageSize,
    emptyPrompt: getNoItemsMessage(capabilities.graph.save === false, createItem, coreStart.application),
    entityName: _i18n.i18n.translate('xpack.graph.listing.table.entityName', {
      defaultMessage: 'graph'
    }),
    entityNamePlural: _i18n.i18n.translate('xpack.graph.listing.table.entityNamePlural', {
      defaultMessage: 'graphs'
    }),
    tableListTitle: _i18n.i18n.translate('xpack.graph.listing.graphsTitle', {
      defaultMessage: 'Graphs'
    }),
    getDetailViewLink: ({
      id
    }) => (0, _url.getEditUrl)(addBasePath, {
      id
    })
  }));
}
function getNoItemsMessage(hideWriteControls, createItem, application) {
  if (hideWriteControls) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
      iconType: "graphApp",
      title: /*#__PURE__*/_react.default.createElement("h1", {
        id: "graphListingHeading"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.graph.listing.noItemsMessage",
        defaultMessage: "Looks like you don't have any graphs."
      }))
    });
  }
  const sampleDataUrl = `${application.getUrlForApp('home')}#/tutorial_directory/sampleData`;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
    iconType: "graphApp",
    title: /*#__PURE__*/_react.default.createElement("h1", {
      id: "graphListingHeading"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.listing.createNewGraph.title",
      defaultMessage: "Create your first graph"
    })),
    body: /*#__PURE__*/_react.default.createElement(_react.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.listing.createNewGraph.combineDataViewFromKibanaAppDescription",
      defaultMessage: "Discover patterns and relationships in your Elasticsearch indices."
    })), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.listing.createNewGraph.newToKibanaDescription",
      defaultMessage: "New to Kibana? Get started with {sampleDataInstallLink}.",
      values: {
        sampleDataInstallLink: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: sampleDataUrl
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.graph.listing.createNewGraph.sampleDataInstallLinkText",
          defaultMessage: "sample data"
        }))
      }
    }))),
    actions: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      onClick: createItem,
      fill: true,
      iconType: "plusInCircle",
      "data-test-subj": "graphCreateGraphPromptButton"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.graph.listing.createNewGraph.createButtonLabel",
      defaultMessage: "Create graph"
    }))
  });
}