"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _i18n = require("@kbn/i18n");
var _reactDom = _interopRequireDefault(require("react-dom"));
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _contentManagementTableList = require("@kbn/content-management-table-list");
require("./index.scss");
var _public = require("@kbn/kibana-react-plugin/public");
var _router = require("./router");
var _check_license = require("../common/check_license");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
Promise.resolve().then(() => _interopRequireWildcard(require('./font_awesome')));
const renderApp = ({
  history,
  element,
  ...deps
}) => {
  const {
    chrome,
    capabilities,
    core
  } = deps;
  const {
    theme$
  } = core.theme;
  if (!capabilities.graph.save) {
    chrome.setBadge({
      text: _i18n.i18n.translate('xpack.graph.badge.readOnly.text', {
        defaultMessage: 'Read only'
      }),
      tooltip: _i18n.i18n.translate('xpack.graph.badge.readOnly.tooltip', {
        defaultMessage: 'Unable to save Graph workspaces'
      }),
      iconType: 'glasses'
    });
  }
  const licenseSubscription = deps.licensing.license$.subscribe(license => {
    const info = (0, _check_license.checkLicense)(license);
    const licenseAllowsToShowThisPage = info.showAppLink && info.enableAppLink;
    if (!licenseAllowsToShowThisPage) {
      if (info.message) {
        deps.core.notifications.toasts.addDanger(info.message);
      }

      // This has to happen in the next tick because otherwise the original navigation
      // bringing us to the graph app in the first place
      // never completes and the browser enters are redirect loop
      setTimeout(() => {
        deps.core.application.navigateToApp('home');
      }, 0);
    }
  });

  // dispatch synthetic hash change event to update hash history objects
  // this is necessary because hash updates triggered by using popState won't trigger this event naturally.
  const unlistenParentHistory = history.listen(() => {
    window.dispatchEvent(new HashChangeEvent('hashchange'));
  });
  const app = /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
    theme$: theme$
  }, /*#__PURE__*/_react.default.createElement(_contentManagementTableList.TableListViewKibanaProvider, {
    core,
    toMountPoint: _public.toMountPoint,
    FormattedRelative: _i18nReact.FormattedRelative
  }, (0, _router.graphRouter)(deps)));
  _reactDom.default.render(app, element);
  element.setAttribute('class', 'gphAppWrapper');
  return () => {
    licenseSubscription.unsubscribe();
    unlistenParentHistory();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;