"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalSearchBarPlugin = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _search_bar = require("./components/search_bar");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class GlobalSearchBarPlugin {
  setup() {
    return {};
  }
  start(core, {
    globalSearch,
    savedObjectsTagging,
    usageCollection
  }) {
    const trackUiMetric = usageCollection ? usageCollection.reportUiCounter.bind(usageCollection, 'global_search_bar') : (metricType, eventName) => {};
    core.chrome.navControls.registerCenter({
      order: 1000,
      mount: container => this.mount({
        container,
        globalSearch,
        savedObjectsTagging,
        navigateToUrl: core.application.navigateToUrl,
        basePathUrl: core.http.basePath.prepend('/plugins/globalSearchBar/assets/'),
        darkMode: core.uiSettings.get('theme:darkMode'),
        theme$: core.theme.theme$,
        trackUiMetric
      })
    });
    return {};
  }
  mount({
    container,
    globalSearch,
    savedObjectsTagging,
    navigateToUrl,
    basePathUrl,
    darkMode,
    theme$,
    trackUiMetric
  }) {
    _reactDom.default.render( /*#__PURE__*/_react.default.createElement(_public.KibanaThemeProvider, {
      theme$: theme$
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, null, /*#__PURE__*/_react.default.createElement(_search_bar.SearchBar, {
      globalSearch: globalSearch,
      navigateToUrl: navigateToUrl,
      taggingApi: savedObjectsTagging,
      basePathUrl: basePathUrl,
      darkMode: darkMode,
      trackUiMetric: trackUiMetric
    }))), container);
    return () => _reactDom.default.unmountComponentAtNode(container);
  }
}
exports.GlobalSearchBarPlugin = GlobalSearchBarPlugin;