"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchBar = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useDebounce = _interopRequireDefault(require("react-use/lib/useDebounce"));
var _useEvent = _interopRequireDefault(require("react-use/lib/useEvent"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _eui = require("@elastic/eui");
var _analytics = require("@kbn/analytics");
var _i18n = require("@kbn/i18n");
var _search_syntax = require("../search_syntax");
var _suggestions = require("../suggestions");
var _lib = require("../lib");
var _popover_footer = require("./popover_footer");
var _popover_placeholder = require("./popover_placeholder");
require("./search_bar.scss");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function (nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isMac = navigator.platform.toLowerCase().indexOf('mac') >= 0;
const blurEvent = new FocusEvent('focusout', {
  bubbles: true
});
const sortByScore = (a, b) => {
  if (a.score < b.score) return 1;
  if (a.score > b.score) return -1;
  return 0;
};
const sortByTitle = (a, b) => {
  const titleA = a.title.toUpperCase(); // ignore upper and lowercase
  const titleB = b.title.toUpperCase(); // ignore upper and lowercase
  if (titleA < titleB) return -1;
  if (titleA > titleB) return 1;
  return 0;
};
const SearchBar = ({
  globalSearch,
  taggingApi,
  navigateToUrl,
  trackUiMetric,
  basePathUrl,
  darkMode
}) => {
  const isMounted = (0, _useMountedState.default)();
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [initialLoad, setInitialLoad] = (0, _react.useState)(false);
  const [searchValue, setSearchValue] = (0, _react.useState)('');
  const [searchTerm, setSearchTerm] = (0, _react.useState)('');
  const [searchRef, setSearchRef] = (0, _react.useState)(null);
  const [buttonRef, setButtonRef] = (0, _react.useState)(null);
  const searchSubscription = (0, _react.useRef)(null);
  const [options, _setOptions] = (0, _react.useState)([]);
  const [searchableTypes, setSearchableTypes] = (0, _react.useState)([]);
  const [showAppend, setShowAppend] = (0, _react.useState)(true);
  const UNKNOWN_TAG_ID = '__unknown__';
  (0, _react.useEffect)(() => {
    if (initialLoad) {
      const fetch = async () => {
        const types = await globalSearch.getSearchableTypes();
        setSearchableTypes(types);
      };
      fetch();
    }
  }, [globalSearch, initialLoad]);
  const loadSuggestions = (0, _react.useCallback)(term => {
    return (0, _suggestions.getSuggestions)({
      searchTerm: term,
      searchableTypes,
      tagCache: taggingApi === null || taggingApi === void 0 ? void 0 : taggingApi.cache
    });
  }, [taggingApi, searchableTypes]);
  const setOptions = (0, _react.useCallback)((_options, suggestions, searchTagIds = []) => {
    if (!isMounted()) {
      return;
    }
    _setOptions([...suggestions.map(_lib.suggestionToOption), ..._options.map(option => {
      var _searchTagIds$filter;
      return (0, _lib.resultToOption)(option, (_searchTagIds$filter = searchTagIds === null || searchTagIds === void 0 ? void 0 : searchTagIds.filter(id => id !== UNKNOWN_TAG_ID)) !== null && _searchTagIds$filter !== void 0 ? _searchTagIds$filter : [], taggingApi === null || taggingApi === void 0 ? void 0 : taggingApi.ui.getTag);
    })]);
  }, [isMounted, _setOptions, taggingApi]);
  (0, _useDebounce.default)(() => {
    if (initialLoad) {
      var _rawParams$term;
      // cancel pending search if not completed yet
      if (searchSubscription.current) {
        searchSubscription.current.unsubscribe();
        searchSubscription.current = null;
      }
      const suggestions = loadSuggestions(searchValue);
      let aggregatedResults = [];
      if (searchValue.length !== 0) {
        trackUiMetric(_analytics.METRIC_TYPE.COUNT, 'search_request');
      }
      const rawParams = (0, _search_syntax.parseSearchParams)(searchValue);
      const tagIds = taggingApi && rawParams.filters.tags ? rawParams.filters.tags.map(tagName => {
        var _taggingApi$ui$getTag;
        return (_taggingApi$ui$getTag = taggingApi.ui.getTagIdFromName(tagName)) !== null && _taggingApi$ui$getTag !== void 0 ? _taggingApi$ui$getTag : UNKNOWN_TAG_ID;
      }) : undefined;
      const searchParams = {
        term: rawParams.term,
        types: rawParams.filters.types,
        tags: tagIds
      };
      // TODO technically a subtle bug here
      // this term won't be set until the next time the debounce is fired
      // so the SearchOption won't highlight anything if only one call is fired
      // in practice, this is hard to spot, unlikely to happen, and is a negligible issue
      setSearchTerm((_rawParams$term = rawParams.term) !== null && _rawParams$term !== void 0 ? _rawParams$term : '');
      searchSubscription.current = globalSearch.find(searchParams, {}).subscribe({
        next: ({
          results
        }) => {
          if (searchValue.length > 0) {
            aggregatedResults = [...results, ...aggregatedResults].sort(sortByScore);
            setOptions(aggregatedResults, suggestions, searchParams.tags);
            return;
          }

          // if searchbar is empty, filter to only applications and sort alphabetically
          results = results.filter(({
            type
          }) => type === 'application');
          aggregatedResults = [...results, ...aggregatedResults].sort(sortByTitle);
          setOptions(aggregatedResults, suggestions, searchParams.tags);
        },
        error: () => {
          // Not doing anything on error right now because it'll either just show the previous
          // results or empty results which is basically what we want anyways
          trackUiMetric(_analytics.METRIC_TYPE.COUNT, 'unhandled_error');
        },
        complete: () => {}
      });
    }
  }, 350, [searchValue, loadSuggestions, searchableTypes, initialLoad]);
  const onKeyDown = (0, _react.useCallback)(event => {
    if (event.key === '/' && (isMac ? event.metaKey : event.ctrlKey)) {
      event.preventDefault();
      trackUiMetric(_analytics.METRIC_TYPE.COUNT, 'shortcut_used');
      if (searchRef) {
        searchRef.focus();
      } else if (buttonRef) {
        buttonRef.children[0].click();
      }
    }
  }, [buttonRef, searchRef, trackUiMetric]);
  const onChange = (0, _react.useCallback)(selection => {
    const selected = selection.find(({
      checked
    }) => checked === 'on');
    if (!selected) {
      return;
    }

    // @ts-ignore - ts error is "union type is too complex to express"
    const {
      url,
      type,
      suggestion
    } = selected;

    // if the type is a suggestion, we change the query on the input and trigger a new search
    // by setting the searchValue (only setting the field value does not trigger a search)
    if (type === '__suggestion__') {
      setSearchValue(suggestion);
      return;
    }

    // errors in tracking should not prevent selection behavior
    try {
      if (type === 'application') {
        var _selected$keys;
        const key = (_selected$keys = selected.keys) !== null && _selected$keys !== void 0 ? _selected$keys : 'unknown';
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, ['user_navigated_to_application', `user_navigated_to_application_${key.toLowerCase().replaceAll(' ', '_')}` // which application
        ]);
      } else {
        trackUiMetric(_analytics.METRIC_TYPE.CLICK, ['user_navigated_to_saved_object', `user_navigated_to_saved_object_${type}` // which type of saved object
        ]);
      }
    } catch (e) {
      // eslint-disable-next-line no-console
      console.log('Error trying to track searchbar metrics', e);
    }
    navigateToUrl(url);
    document.activeElement.blur();
    if (searchRef) {
      clearField();
      searchRef.dispatchEvent(blurEvent);
    }
  }, [trackUiMetric, navigateToUrl, searchRef]);
  const clearField = () => setSearchValue('');
  const noMatchesMessage = /*#__PURE__*/_react.default.createElement(_popover_placeholder.PopoverPlaceholder, {
    darkMode: darkMode,
    basePath: basePathUrl
  });
  const emptyMessage = /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    justifyContent: "center",
    style: {
      minHeight: '300px'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })));
  const placeholderText = _i18n.i18n.translate('xpack.globalSearchBar.searchBar.placeholder', {
    defaultMessage: 'Find apps, content, and more.'
  });
  const keyboardShortcutTooltip = `${_i18n.i18n.translate('xpack.globalSearchBar.searchBar.shortcutTooltip.description', {
    defaultMessage: 'Keyboard shortcut'
  })}: ${isMac ? _i18n.i18n.translate('xpack.globalSearchBar.searchBar.shortcutTooltip.macCommandDescription', {
    defaultMessage: 'Command + /'
  }) : _i18n.i18n.translate('xpack.globalSearchBar.searchBar.shortcutTooltip.windowsCommandDescription', {
    defaultMessage: 'Control + /'
  })}`;
  (0, _useEvent.default)('keydown', onKeyDown);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSelectableTemplateSitewide, {
    isPreFiltered: true,
    onChange: onChange,
    options: options,
    className: "kbnSearchBar",
    popoverButtonBreakpoints: ['xs', 's'],
    singleSelection: true,
    renderOption: option => (0, _eui.euiSelectableTemplateSitewideRenderOptions)(option, searchTerm),
    searchProps: {
      value: searchValue,
      onInput: e => setSearchValue(e.currentTarget.value),
      'data-test-subj': 'nav-search-input',
      inputRef: setSearchRef,
      compressed: true,
      'aria-label': placeholderText,
      placeholder: placeholderText,
      onFocus: () => {
        trackUiMetric(_analytics.METRIC_TYPE.COUNT, 'search_focus');
        setInitialLoad(true);
        setShowAppend(false);
      },
      onBlur: () => {
        setShowAppend(!searchValue.length);
      },
      fullWidth: true,
      append: showAppend ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, {
        title: keyboardShortcutTooltip,
        css: {
          fontFamily: euiTheme.font.familyCode
        }
      }, isMac ? '⌘/' : '^/') : undefined
    },
    emptyMessage: emptyMessage,
    noMatchesMessage: noMatchesMessage,
    popoverProps: {
      'data-test-subj': 'nav-search-popover',
      panelClassName: 'navSearch__panel',
      repositionOnScroll: true,
      buttonRef: setButtonRef,
      panelStyle: {
        marginTop: '6px'
      }
    },
    popoverButton: /*#__PURE__*/_react.default.createElement(_eui.EuiHeaderSectionItemButton, {
      "aria-label": _i18n.i18n.translate('xpack.globalSearchBar.searchBar.mobileSearchButtonAriaLabel', {
        defaultMessage: 'Site-wide search'
      })
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "search",
      size: "m"
    })),
    popoverFooter: /*#__PURE__*/_react.default.createElement(_popover_footer.PopoverFooter, {
      isMac: isMac
    })
  });
};
exports.SearchBar = SearchBar;