"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MAX_RETRY_COUNT = void 0;
exports.getRetryParams = getRetryParams;
var _bulk_action_types = require("./bulk_action_types");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MAX_RETRY_COUNT = 20;
exports.MAX_RETRY_COUNT = MAX_RETRY_COUNT;
function getRetryParams(taskType, retryParams) {
  // update tags will retry with tags filter
  return taskType === _bulk_action_types.BulkActionTaskType.UPDATE_AGENT_TAGS_RETRY ? {
    ...retryParams,
    pitId: undefined,
    searchAfter: undefined
  } : retryParams;
}