"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerRoutes = void 0;
var _constants = require("../../constants");
var _types = require("../../types");
var _handlers = require("./handlers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const registerRoutes = router => {
  // Rotate fleet message signing key pair
  router.post({
    path: _constants.MESSAGE_SIGNING_SERVICE_API_ROUTES.ROTATE_KEY_PAIR,
    validate: _types.RotateKeyPairSchema,
    fleetAuthz: {
      fleet: {
        all: true
      }
    }
  }, _handlers.rotateKeyPairHandler);
};
exports.registerRoutes = registerRoutes;